/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.user.authenticator;

import com.opensymphony.module.user.authenticator.AbstractAuthenticator;
import com.opensymphony.module.user.authenticator.AuthenticationException;
import com.opensymphony.module.user.authenticator.Authenticator;
import com.opensymphony.module.user.authenticator.jboss.JBossAuthenticator;
import com.opensymphony.module.user.authenticator.orion.OrionAuthenticator;

public class SmartAuthenticator
extends AbstractAuthenticator {
    private transient Authenticator authenticator = null;

    public boolean login(String username, String password) throws AuthenticationException {
        if (this.authenticator == null) {
            this.authenticator = this.loadOrionAuthenticator();
        }
        if (this.authenticator == null) {
            this.authenticator = this.loadJBossAuthenticator();
        }
        if (this.authenticator == null) {
            throw new AuthenticationException("SmartAuthenticator could not find authenticator to load");
        }
        return this.authenticator.login(username, password);
    }

    private Authenticator loadOrionAuthenticator() {
        try {
            Thread.currentThread().getContextClassLoader().loadClass("com.evermind.security.RoleManager");
            OrionAuthenticator orionAuth = new OrionAuthenticator();
            orionAuth.init(this.properties);
            return orionAuth;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private Authenticator loadJBossAuthenticator() {
        try {
            Thread.currentThread().getContextClassLoader().loadClass("org.jboss.security.AuthenticationManager");
            JBossAuthenticator jbossAuth = new JBossAuthenticator();
            jbossAuth.init(this.properties);
            return jbossAuth;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

