/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.user.provider.ejb;

import com.opensymphony.module.user.Entity;
import com.opensymphony.module.user.UserManagerImplementationException;
import com.opensymphony.module.user.provider.CredentialsProvider;
import com.opensymphony.module.user.provider.ejb.entity.OsMembership;
import com.opensymphony.module.user.provider.ejb.entity.OsMembershipHome;
import com.opensymphony.module.user.provider.ejb.entity.OsUser;
import com.opensymphony.module.user.provider.ejb.entity.OsUserHome;
import com.opensymphony.util.EJBUtils;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.ObjectNotFoundException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EJBCredentialsProvider
implements CredentialsProvider {
    private OsUserHome userHome;
    private OsMembershipHome membershipHome;
    private static final Log logger = LogFactory.getLog((Class)(class$com$opensymphony$module$user$provider$ejb$EJBCredentialsProvider == null ? (class$com$opensymphony$module$user$provider$ejb$EJBCredentialsProvider = EJBCredentialsProvider.class$("com.opensymphony.module.user.provider.ejb.EJBCredentialsProvider")) : class$com$opensymphony$module$user$provider$ejb$EJBCredentialsProvider));
    static /* synthetic */ Class class$com$opensymphony$module$user$provider$ejb$EJBCredentialsProvider;
    static /* synthetic */ Class class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome;
    static /* synthetic */ Class class$com$opensymphony$module$user$provider$ejb$entity$OsMembershipHome;
    static /* synthetic */ Class class$com$opensymphony$module$user$provider$ejb$entity$OsUser;

    public boolean init(Properties properties) {
        logger.debug((Object)"EJBCredentialsProvider.init");
        try {
            InitialContext jndiContext = new InitialContext();
            logger.debug((Object)"Looking up UserHome at location: ");
            String location = properties.getProperty("location", "User");
            logger.info((Object)("Looking up UserHome at location: " + location));
            try {
                Object obj = jndiContext.lookup(location);
                this.userHome = (OsUserHome)PortableRemoteObject.narrow((Object)obj, (Class)(class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome = EJBCredentialsProvider.class$("com.opensymphony.module.user.provider.ejb.entity.OsUserHome")) : class$com$opensymphony$module$user$provider$ejb$entity$OsUserHome));
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                logger.fatal((Object)e);
                throw new UserManagerImplementationException("Could not lookup User home interface", e);
            }
            String membershipLocation = properties.getProperty("location.membership", "OsMembership");
            try {
                this.membershipHome = (OsMembershipHome)EJBUtils.lookup(membershipLocation, class$com$opensymphony$module$user$provider$ejb$entity$OsMembershipHome == null ? (class$com$opensymphony$module$user$provider$ejb$entity$OsMembershipHome = EJBCredentialsProvider.class$("com.opensymphony.module.user.provider.ejb.entity.OsMembershipHome")) : class$com$opensymphony$module$user$provider$ejb$entity$OsMembershipHome);
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            return true;
        }
        catch (NamingException e) {
            logger.fatal((Object)e);
            throw new UserManagerImplementationException("Could not lookup User home interface", e);
        }
    }

    public boolean handles(String name) {
        logger.debug((Object)("EJBCredentialsProvider.handles user: " + name));
        if (this.userHome == null) {
            logger.fatal((Object)"userHome ist NULL");
        }
        try {
            this.userHome.findByName(name);
            return true;
        }
        catch (ObjectNotFoundException e) {
            return false;
        }
        catch (Exception e) {
            throw new UserManagerImplementationException(e);
        }
    }

    public List list() {
        logger.debug((Object)"EJBCredentialsProvider.list");
        ArrayList<String> result = null;
        try {
            Collection users;
            if (this.userHome == null) {
                logger.fatal((Object)"userHome null!");
            }
            if ((users = this.userHome.findAll()) != null) {
                result = new ArrayList<String>(users.size());
                Iterator i = users.iterator();
                while (i.hasNext()) {
                    String name;
                    OsUser user = (OsUser)EJBUtils.narrow(i.next(), class$com$opensymphony$module$user$provider$ejb$entity$OsUser == null ? EJBCredentialsProvider.class$("com.opensymphony.module.user.provider.ejb.entity.OsUser") : class$com$opensymphony$module$user$provider$ejb$entity$OsUser);
                    try {
                        name = user.getName();
                    }
                    catch (Exception e) {
                        logger.debug((Object)"No Name found");
                        name = "Default";
                    }
                    result.add(name);
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new UserManagerImplementationException(e);
        }
    }

    public boolean load(String name, Entity.Accessor accessor) {
        accessor.setMutable(true);
        return true;
    }

    public boolean store(String name, Entity.Accessor accessor) {
        logger.info((Object)("name: " + name));
        return true;
    }

    public boolean create(String name) {
        logger.info((Object)("create() user name = " + name));
        try {
            this.userHome.create(null, name);
            return true;
        }
        catch (CreateException e) {
            logger.error((Object)("CreateException creating : " + name), (Throwable)e);
            return false;
        }
        catch (Exception e) {
            throw new UserManagerImplementationException(e);
        }
    }

    public boolean remove(String name) {
        logger.debug((Object)"EJBCredentialsProvider.remove");
        try {
            Collection c = this.membershipHome.findByUser(name);
            Iterator itr = c.iterator();
            while (itr.hasNext()) {
                try {
                    OsMembership home = (OsMembership)itr.next();
                    home.remove();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.userHome.findByName(name).remove();
            return true;
        }
        catch (ObjectNotFoundException e) {
            return false;
        }
        catch (Exception e) {
            throw new UserManagerImplementationException(e);
        }
    }

    public boolean authenticate(String name, String password) {
        logger.debug((Object)"EJBCredentialsProvider.authenticate");
        try {
            return this.userHome.findByName(name).authenticate(password);
        }
        catch (ObjectNotFoundException e) {
            return false;
        }
        catch (Exception e) {
            throw new UserManagerImplementationException(e);
        }
    }

    public boolean changePassword(String name, String password) {
        logger.info((Object)"EJBCredentialsProvider.changePassword");
        try {
            this.userHome.findByName(name).setPassword(password);
            return true;
        }
        catch (ObjectNotFoundException e) {
            return false;
        }
        catch (Exception e) {
            throw new UserManagerImplementationException(e);
        }
    }

    public void flushCaches() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

