/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.user.provider.ejb.entity;

import com.opensymphony.ejb.AbstractEntityAdapter;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.user.provider.ejb.util.md5.MD5Crypt;
import java.rmi.RemoteException;
import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

public abstract class OsUserBean
extends AbstractEntityAdapter
implements EntityBean {
    EntityContext entityContext;
    private Long numberOfPrimaryKey;
    public static final Long PASS_MUST_CHANGE_TIME_NEVER = new Long(Integer.MAX_VALUE);

    public Long ejbCreate(Long id, String name) throws CreateException {
        return this.ejbCreate(id, name, true);
    }

    public Long ejbCreate(Long id, String name, boolean isUser) throws CreateException {
        this.sequenceName = "os.User";
        try {
            id = new Long(this.nextLong());
            this.setId(id);
            this.setName(name);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CreateException(e.getMessage());
        }
        this.setWorkstations("" + !isUser);
        this.setLoginShell("/bin/false");
        this.setGidNumber(new Long(-1L));
        this.setHomeDirectory("");
        this.setShadowActive(new Long(0L));
        this.setShadowExpire(new Long(0L));
        this.setShadowFlag(new Long(0L));
        this.setShadowMax(new Long(0L));
        this.setShadowMin(new Long(0L));
        this.setShadowWarning(new Long(0L));
        this.setUidNumber(new Long(-1L));
        this.setApplicationAuthenticationEnabled(new Long(1L));
        this.setLdapAuthenticationEnabled(new Long(1L));
        Long time = new Long(System.currentTimeMillis() / 1000L);
        this.setPassMustChangeTime(PASS_MUST_CHANGE_TIME_NEVER);
        this.setPassCanChangeTime(time);
        this.setPassLastSetTime(time);
        return null;
    }

    public void ejbPostCreate(Long id, String name) throws CreateException {
    }

    public void ejbPostCreate(Long id, String name, boolean isUser) throws CreateException {
    }

    public void ejbRemove() throws RemoveException {
    }

    public abstract void setId(Long var1);

    public abstract void setName(String var1);

    public abstract void setPasswordHash(String var1);

    public abstract void setUidNumber(Long var1);

    public abstract void setGidNumber(Long var1);

    public abstract void setLoginShell(String var1);

    public abstract void setHomeDirectory(String var1);

    public abstract void setShadowMin(Long var1);

    public abstract void setShadowMax(Long var1);

    public abstract void setShadowWarning(Long var1);

    public abstract void setShadowActive(Long var1);

    public abstract void setShadowExpire(Long var1);

    public abstract void setShadowFlag(Long var1);

    public abstract void setDomain(String var1);

    public abstract void setDir_drive(String var1);

    public abstract void setLogin_script(String var1);

    public abstract void setWorkstations(String var1);

    public abstract void setUser_sid(String var1);

    public abstract void setLm_pw(String var1);

    public abstract void setNt_pw(String var1);

    public abstract void setProfilePath(String var1);

    public abstract void setLogonTime(Long var1);

    public abstract void setLogoffTime(Long var1);

    public abstract void setKickOffTime(Long var1);

    public abstract void setPassLastSetTime(Long var1);

    public abstract void setPassCanChangeTime(Long var1);

    public abstract void setPassMustChangeTime(Long var1);

    public abstract void setAcctCtrl(String var1);

    public abstract void setApplicationAuthenticationEnabled(Long var1);

    public abstract void setSambaDir(String var1);

    public abstract void setDescription(String var1);

    public abstract void setSambaGroupId(Long var1);

    public abstract void setLdapAuthenticationEnabled(Long var1);

    public abstract void setShadowLastChange(Long var1);

    public abstract Long getId();

    public abstract String getName();

    public abstract String getPasswordHash();

    public abstract Long getUidNumber();

    public abstract Long getGidNumber();

    public abstract String getLoginShell();

    public abstract String getHomeDirectory();

    public abstract Long getShadowMin();

    public abstract Long getShadowMax();

    public abstract Long getShadowWarning();

    public abstract Long getShadowActive();

    public abstract Long getShadowExpire();

    public abstract Long getShadowFlag();

    public abstract String getDomain();

    public abstract String getDir_drive();

    public abstract String getLogin_script();

    public abstract String getWorkstations();

    public abstract String getUser_sid();

    public abstract String getLm_pw();

    public abstract String getNt_pw();

    public abstract String getProfilePath();

    public abstract Long getLogonTime();

    public abstract Long getLogoffTime();

    public abstract Long getKickOffTime();

    public abstract Long getPassLastSetTime();

    public abstract Long getPassCanChangeTime();

    public abstract Long getPassMustChangeTime();

    public abstract String getAcctCtrl();

    public abstract Long getApplicationAuthenticationEnabled();

    public abstract String getSambaDir();

    public abstract String getDescription();

    public abstract Long getSambaGroupId();

    public abstract Long getLdapAuthenticationEnabled();

    public abstract Long getShadowLastChange();

    public void ejbLoad() {
    }

    public void ejbStore() {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void unsetEntityContext() {
        this.entityContext = null;
    }

    public void setEntityContext(EntityContext context) {
        this.setContext(context);
    }

    public boolean authenticate(String password) {
        if (password == null || this.getPasswordHash() == null || password.length() == 0) {
            return false;
        }
        String userSalt = this.getPasswordHash().substring(10, 18);
        String algorithm = this.getPasswordHash().substring(0, 7);
        String passwordGot = algorithm + MD5Crypt.crypt(password, userSalt);
        return passwordGot.equals(this.getPasswordHash());
    }

    public void setPassword(String password) {
        this.setPasswordHash(this.createHash(password));
    }

    public PropertySet getPropertySet() {
        try {
            return this.locatePropertySet(this.getId());
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String createHash(String original) {
        String hash = "{CRYPT}" + MD5Crypt.crypt(original, this.createSaltString());
        return hash;
    }

    private boolean compareHash(String hashedValue, String unhashedValue) {
        return hashedValue.equals(this.createHash(unhashedValue));
    }

    private String createSaltString() {
        String salt = new String();
        int i = 0;
        while (i < 7) {
            Character random = new Character((char)((Math.random() < 0.5 ? 64 : 96) | 1 + (int)(Math.random() * 26.0)));
            salt = salt.concat(random.toString());
            ++i;
        }
        return salt;
    }
}

