/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.user.provider.file;

import com.opensymphony.module.user.provider.file.SerializableCredentialsProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

class SerializableUserCache
implements Serializable {
    protected Map users = new HashMap();
    private static transient SerializableUserCache instance;

    private SerializableUserCache() {
    }

    static SerializableUserCache getInstance() {
        if (instance == null) {
            instance = SerializableUserCache.load();
        }
        return instance;
    }

    protected static SerializableUserCache load() {
        try {
            FileInputStream fis = new FileInputStream(new File(SerializableCredentialsProvider.storeFile));
            ObjectInputStream ois = new ObjectInputStream(fis);
            SerializableUserCache o = (SerializableUserCache)ois.readObject();
            fis.close();
            return o;
        }
        catch (Exception e) {
            SerializableCredentialsProvider.log.fatal((Object)("cannot store in file " + SerializableCredentialsProvider.storeFile + ". Create a new blank store."));
            return new SerializableUserCache();
        }
    }

    protected static boolean store() {
        try {
            FileOutputStream fos = new FileOutputStream(new File(SerializableCredentialsProvider.storeFile));
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(SerializableUserCache.getInstance());
            fos.close();
            return true;
        }
        catch (Exception e) {
            SerializableCredentialsProvider.log.fatal((Object)("cannot store in file " + SerializableCredentialsProvider.storeFile + "."));
            return false;
        }
    }
}

