/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.user.provider.jdbc;

import com.opensymphony.module.user.Entity;
import com.opensymphony.module.user.provider.UserProvider;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseJDBCProvider
implements UserProvider {
    private static final Log log = LogFactory.getLog((Class)(class$com$opensymphony$module$user$provider$jdbc$BaseJDBCProvider == null ? (class$com$opensymphony$module$user$provider$jdbc$BaseJDBCProvider = BaseJDBCProvider.class$("com.opensymphony.module.user.provider.jdbc.BaseJDBCProvider")) : class$com$opensymphony$module$user$provider$jdbc$BaseJDBCProvider));
    protected String userTable;
    protected String groupTable;
    protected String membershipTable;
    protected String userName;
    protected String userPassword;
    protected String groupName;
    protected String membershipUserName;
    protected String membershipGroupName;
    protected String connectionParameter;
    protected String databaseUserName;
    protected String databasePassword;
    protected DataSource ds;
    static /* synthetic */ Class class$com$opensymphony$module$user$provider$jdbc$BaseJDBCProvider;

    public boolean init(Properties props) {
        this.userTable = (String)props.get("user.table");
        this.groupTable = (String)props.get("group.table");
        this.membershipTable = (String)props.get("membership.table");
        this.userName = (String)props.get("user.name");
        this.userPassword = (String)props.get("user.password");
        this.groupName = (String)props.get("group.name");
        this.membershipUserName = (String)props.get("membership.userName");
        this.membershipGroupName = (String)props.get("membership.groupName");
        this.databaseUserName = (String)props.get("datasourceUser");
        this.databasePassword = (String)props.get("datasourcePassword");
        this.connectionParameter = (String)props.get("datasourceParameter");
        String dataSourceDriver = (String)props.get("datasource");
        if (!dataSourceDriver.equals("oracle.jdbc.driver.OracleDriver")) {
            log.fatal((Object)("Could not load JDBCDatabaseConnection" + dataSourceDriver));
            return false;
        }
        log.info((Object)"DataSource Parameters loaded");
        try {
            Class.forName(dataSourceDriver).newInstance();
        }
        catch (Exception e) {
            log.fatal((Object)("Could not get Connection to JDBCDatabase" + dataSourceDriver));
            return false;
        }
        return true;
    }

    public boolean load(String name, Entity.Accessor accessor) {
        accessor.setMutable(true);
        return true;
    }

    public boolean store(String name, Entity.Accessor accessor) {
        return true;
    }

    public boolean create(String name) {
        return true;
    }

    public boolean remove(String name) {
        return true;
    }

    public void flushCaches() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

