/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.user.test;

import com.opensymphony.module.user.DuplicateEntityException;
import com.opensymphony.module.user.EntityNotFoundException;
import com.opensymphony.module.user.Group;
import com.opensymphony.module.user.User;
import com.opensymphony.module.user.UserManager;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;

public class UserTest
extends TestCase {
    public static final Logger logger = Logger.getLogger((Class)(class$com$opensymphony$module$user$test$UserTest == null ? (class$com$opensymphony$module$user$test$UserTest = UserTest.class$("com.opensymphony.module.user.test.UserTest")) : class$com$opensymphony$module$user$test$UserTest));
    UserManager um;
    static /* synthetic */ Class class$com$opensymphony$module$user$test$UserTest;

    public UserTest(String name) throws Exception {
        super(name);
        BasicConfigurator.configure();
        logger.debug((Object)"UserTest()");
        logger.debug((Object)"UserTest()");
        try {
            this.um = UserManager.getInstance();
            try {
                User joetest = this.um.getUser("joetest");
                joetest.remove();
            }
            catch (EntityNotFoundException e) {
                // empty catch block
            }
            try {
                User miketest = this.um.getUser("miketest");
                miketest.remove();
            }
            catch (EntityNotFoundException e) {
                // empty catch block
            }
            try {
                logger.debug((Object)"osuser-people");
                Group people = this.um.getGroup("osuser-people");
                people.remove();
            }
            catch (EntityNotFoundException e) {
                // empty catch block
            }
            try {
                Group admins = this.um.getGroup("osuser-admins");
                admins.remove();
            }
            catch (EntityNotFoundException e) {}
        }
        catch (Exception e) {
            logger.error((Object)"Error cleaning up!", (Throwable)e);
            logger.debug((Object)"cleaning");
            throw e;
        }
    }

    public static Test suite() {
        return new TestSuite(class$com$opensymphony$module$user$test$UserTest == null ? (class$com$opensymphony$module$user$test$UserTest = UserTest.class$("com.opensymphony.module.user.test.UserTest")) : class$com$opensymphony$module$user$test$UserTest);
    }

    protected void setUp() throws Exception {
    }

    public void testCreateUsers() throws Exception {
        logger.debug((Object)"testCreateUsers()");
        int size = this.um.getUsers().size();
        User joetest = this.um.createUser("joetest");
        joetest.setFullName("joetest Walnes");
        joetest.setEmail("joetest@opensymphony.com");
        joetest.setPassword("cow");
        joetest.getPropertySet().setBoolean("australian", false);
        joetest.store();
        Assert.assertEquals((int)(size + 1), (int)this.um.getUsers().size());
        User miketest = this.um.createUser("miketest");
        miketest.setFullName("miketest Cannon-Brookes");
        miketest.setEmail("miketest@opensymphony.com");
        miketest.setPassword("chicken");
        miketest.getPropertySet().setBoolean("australian", true);
        miketest.store();
        Assert.assertEquals((int)(size + 2), (int)this.um.getUsers().size());
        try {
            User bad = this.um.createUser("joetest");
            Assert.fail((String)"Created user that already existed");
        }
        catch (DuplicateEntityException e) {
            // empty catch block
        }
        Assert.assertEquals((int)(size + 2), (int)this.um.getUsers().size());
    }

    public void testUserValues() throws Exception {
        logger.debug((Object)"testUserValues()");
        User joetest = this.um.getUser("joetest");
        User miketest = this.um.getUser("miketest");
        Assert.assertTrue((String)"mutable", (boolean)joetest.isMutable());
        Assert.assertEquals((Object)"joetest", (Object)joetest.getName());
        Assert.assertEquals((Object)"joetest@opensymphony.com", (Object)joetest.getEmail());
        Assert.assertEquals((Object)"miketest@opensymphony.com", (Object)miketest.getEmail());
        Assert.assertEquals((Object)"joetest Walnes", (Object)joetest.getFullName());
        Assert.assertTrue((String)"authenticateGood", (boolean)joetest.authenticate("cow"));
        Assert.assertTrue((String)"authenticateBad", (!joetest.authenticate("blah") ? 1 : 0) != 0);
        Assert.assertTrue((String)"authenticateBad", (!joetest.authenticate("blah") ? 1 : 0) != 0);
        Assert.assertTrue((String)"joetest's not supposed to be australian", (!joetest.getPropertySet().getBoolean("australian") ? 1 : 0) != 0);
        Assert.assertTrue((String)"miketest's supposed to be australian", (boolean)miketest.getPropertySet().getBoolean("australian"));
        try {
            User bad = this.um.getUser("dfgdjfgh");
            Assert.fail((String)"Looked up user that doesn't exist.");
        }
        catch (EntityNotFoundException e) {}
    }

    public void testCreateGroups() throws Exception {
        logger.debug((Object)"testCreateGroups()");
        int size = this.um.getGroups().size();
        Group people = this.um.createGroup("osuser-people");
        Group admins = this.um.createGroup("osuser-admins");
        Assert.assertEquals((int)(size + 2), (int)this.um.getGroups().size());
        try {
            Group bad = this.um.createGroup("osuser-people");
            Assert.fail((String)"Created group that already existed");
        }
        catch (DuplicateEntityException e) {
            // empty catch block
        }
        Assert.assertEquals((int)(size + 2), (int)this.um.getGroups().size());
    }

    public void testMemberships() throws Exception {
        User joetest = this.um.getUser("joetest");
        User miketest = this.um.getUser("miketest");
        Group people = this.um.getGroup("osuser-people");
        Group admins = this.um.getGroup("osuser-admins");
        Assert.assertTrue((!joetest.inGroup(people) ? 1 : 0) != 0);
        Assert.assertTrue((!joetest.inGroup(admins) ? 1 : 0) != 0);
        Assert.assertTrue((!miketest.inGroup(people) ? 1 : 0) != 0);
        Assert.assertTrue((!miketest.inGroup("osuser-admins") ? 1 : 0) != 0);
        Assert.assertTrue((!miketest.inGroup("dfdsfd") ? 1 : 0) != 0);
        Assert.assertTrue((!admins.containsUser("joetest") ? 1 : 0) != 0);
        Assert.assertTrue((!people.containsUser(miketest) ? 1 : 0) != 0);
        Assert.assertTrue((!admins.containsUser("flumpy") ? 1 : 0) != 0);
        joetest.addToGroup(people);
        people.store();
        Assert.assertTrue((boolean)joetest.inGroup(people));
        Assert.assertTrue((boolean)joetest.inGroup("osuser-people"));
        Assert.assertTrue((!joetest.inGroup(admins) ? 1 : 0) != 0);
        Assert.assertTrue((!miketest.inGroup(people) ? 1 : 0) != 0);
        admins.addUser(miketest);
        admins.store();
        Assert.assertTrue((boolean)miketest.inGroup(admins));
        Assert.assertTrue((boolean)miketest.inGroup("osuser-admins"));
        Assert.assertTrue((boolean)admins.containsUser(miketest));
        Assert.assertTrue((!admins.containsUser(joetest) ? 1 : 0) != 0);
        Assert.assertTrue((!miketest.inGroup(people) ? 1 : 0) != 0);
        Assert.assertTrue((!joetest.inGroup("osuser-admins") ? 1 : 0) != 0);
        Assert.assertTrue((!people.containsUser(miketest) ? 1 : 0) != 0);
    }

    public void testGroupValues() throws Exception {
        logger.debug((Object)"testGroupValues()");
        Group people = this.um.getGroup("osuser-people");
        Group admins = this.um.getGroup("osuser-admins");
        Assert.assertEquals((Object)"osuser-people", (Object)people.getName());
        Assert.assertEquals((Object)"osuser-admins", (Object)admins.getName());
        try {
            Group bad = this.um.getGroup("dfgdjfgh");
            logger.error((Object)"Looked up group that doesn't exist.");
            Assert.fail((String)"Looked up group that doesn't exist.");
        }
        catch (EntityNotFoundException e) {}
    }

    public void testClear() throws Exception {
        logger.debug((Object)"testClear()");
        int userSize = this.um.getUsers().size();
        int groupSize = this.um.getGroups().size();
        User joetest = this.um.getUser("joetest");
        User miketest = this.um.getUser("miketest");
        Group people = this.um.getGroup("osuser-people");
        Group admins = this.um.getGroup("osuser-admins");
        joetest.remove();
        miketest.remove();
        Assert.assertEquals((int)(userSize - 2), (int)this.um.getUsers().size());
        people.remove();
        admins.remove();
        Assert.assertEquals((int)(groupSize - 2), (int)this.um.getGroups().size());
    }

    public void myTest() throws Exception {
        logger.debug((Object)"Starting my own Test");
        User dieter = null;
        dieter = this.um.createUser("dieter");
        dieter.setFullName("Dieter Zeller");
        dieter.setEmail("didi@sbox");
        dieter.setPassword("dieterpasswd");
        dieter.getPropertySet().setBoolean("australian", false);
        dieter.getPropertySet().setString("Adresse", "DasAdresse");
        dieter.store();
    }

    public static void main(String[] args) {
        try {
            UserTest test = new UserTest("Dieter");
            test.myTest();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

