/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.util;

import com.opensymphony.util.OrderedMap;
import com.opensymphony.util.TextUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.ejb.FinderException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EJBUtils {
    private static final Log logger = LogFactory.getLog((Class)(class$com$opensymphony$util$EJBUtils == null ? (class$com$opensymphony$util$EJBUtils = EJBUtils.class$("com.opensymphony.util.EJBUtils")) : class$com$opensymphony$util$EJBUtils));
    private static HashMap finderMethods = new HashMap();
    private static Set ignoreEnvLocations = new HashSet();
    static /* synthetic */ Class class$com$opensymphony$util$EJBUtils;

    public static final Context getRoot() throws NamingException, RemoteException {
        return new InitialContext();
    }

    public static final Object createStateless(String location) throws Throwable {
        try {
            Object home = EJBUtils.lookup(location);
            Method createMethod = home.getClass().getDeclaredMethod("create", null);
            return createMethod.invoke(home, null);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public static final EJBObject findEntity(EJBHome home, String id) throws RemoteException, FinderException {
        block19: {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("findEntity(" + home + ",'" + id + "') method entered"));
            }
            try {
                Class<?> homeClass = home.getClass();
                OrderedMap params = new OrderedMap();
                params.put(Integer.TYPE, new Integer(TextUtils.parseInt(id)));
                params.put(Long.TYPE, new Long(TextUtils.parseLong(id)));
                params.put("java.lang.Integer", new Integer(TextUtils.parseInt(id)));
                params.put("java.lang.Long", new Long(TextUtils.parseLong(id)));
                params.put("java.lang.String", id);
                Iterator it = params.iterator();
                while (it.hasNext()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"iterate");
                    }
                    Object classType = it.next();
                    if (logger.isDebugEnabled()) {
                        logger.debug(classType);
                    }
                    try {
                        Object[] args;
                        EJBObject result;
                        Method m = null;
                        if (!finderMethods.containsKey(homeClass)) {
                            logger.debug((Object)"Method not in cache");
                            Class[] theClass = new Class[]{classType instanceof String ? Class.forName((String)classType) : (Class<?>)classType};
                            m = homeClass.getMethod("findByPrimaryKey", theClass);
                            finderMethods.put(homeClass, m);
                        } else {
                            logger.debug((Object)"Method in cache");
                            m = (Method)finderMethods.get(homeClass);
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("findEntity() attempting " + classType));
                        }
                        if ((result = (EJBObject)m.invoke((Object)home, args = new Object[]{params.get(classType)})) != null) {
                            logger.debug((Object)"Found result");
                            return result;
                        }
                        logger.debug((Object)"No result found");
                    }
                    catch (ClassCastException e) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)e);
                    }
                    catch (ClassNotFoundException e) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)e);
                    }
                    catch (NoSuchMethodException e) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)e);
                    }
                    catch (IllegalAccessException e) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)e);
                    }
                    catch (InvocationTargetException e) {
                        Throwable t = e.getTargetException();
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)e);
                        }
                        if (t instanceof RemoteException) {
                            throw (RemoteException)t;
                        }
                        if (!(t instanceof FinderException)) continue;
                        throw (FinderException)t;
                    }
                }
            }
            catch (NullPointerException e) {
                if (!logger.isDebugEnabled()) break block19;
                logger.debug((Object)e);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"findEntity() found nothing");
        }
        return null;
    }

    public static final EJBObject findEntity(EJBHome home, int id) throws RemoteException, FinderException {
        return EJBUtils.findEntity(home, "" + id);
    }

    public static final EJBObject findEntity(EJBHome home, long id) throws RemoteException, FinderException {
        return EJBUtils.findEntity(home, "" + id);
    }

    public static final Object lookup(String location, Class classType) throws NamingException, RemoteException {
        return EJBUtils.narrow(EJBUtils.lookup(location), classType);
    }

    public static final Object lookup(String location) throws NamingException, RemoteException {
        NamingException notFoundE = null;
        if (ignoreEnvLocations.contains(location)) {
            try {
                return EJBUtils.getRoot().lookup(location);
            }
            catch (NamingException e) {
                ignoreEnvLocations.remove(location);
                notFoundE = e;
            }
        }
        try {
            return EJBUtils.getRoot().lookup("java:comp/env/" + location);
        }
        catch (NamingException e) {
            if (notFoundE != null) {
                throw notFoundE;
            }
            ignoreEnvLocations.add(location);
            return EJBUtils.getRoot().lookup(location);
        }
    }

    public static final Object narrow(Object o, Class classType) {
        return PortableRemoteObject.narrow((Object)o, (Class)classType);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

