/*
 * Decompiled with CFR 0.152.
 */
package server.Management.acl;

import at.tugraz.genome.usermanagement.server.MessageBean;
import at.tugraz.genome.usermanagement.server.acl.VO.AclImportVO;
import at.tugraz.genome.usermanagement.server.acl.VO.AclVO;
import at.tugraz.genome.usermanagement.server.group.VO.SmallGroupVO;
import at.tugraz.genome.usermanagement.server.resource.VO.ResourceVO;
import at.tugraz.genome.usermanagement.xml.AclParser;
import at.tugraz.genome.usermanagement.xml.AclXMLGenerator;
import at.tugraz.genome.usermanagement.xml.XMLFileLoader;
import at.tugraz.genome.usermanagement.xml.XMLFileWriter;
import com.opensymphony.module.access.AccessManager;
import com.opensymphony.module.access.DuplicateKeyException;
import com.opensymphony.module.access.ImmutableException;
import com.opensymphony.module.access.NotFoundException;
import com.opensymphony.module.access.provider.BaseProvider;
import com.opensymphony.module.access.provider.ejb.AclEntity;
import com.opensymphony.module.access.provider.ejb.OsAcl;
import com.opensymphony.module.access.provider.ejb.OsAclHome;
import com.opensymphony.module.access.provider.ejb.OsGroupInRealmHome;
import com.opensymphony.module.access.provider.ejb.ResourceEntity;
import com.opensymphony.module.access.provider.ejb.VOFactory.AclVOFactory;
import com.opensymphony.module.access.provider.ejb.VOFactory.ResourceVOFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;
import server.Management.Management;
import server.Management.group.VOFactory.SmallGroupVOFactory;

public class AclManagerBean
extends Management
implements SessionBean {
    SessionContext sessionContext;
    private static final Log logger = LogFactory.getLog((Class)(class$server$Management$acl$AclManagerBean == null ? (class$server$Management$acl$AclManagerBean = AclManagerBean.class$("server.Management.acl.AclManagerBean")) : class$server$Management$acl$AclManagerBean));
    private AccessManager accessManager_;
    static /* synthetic */ Class class$server$Management$acl$AclManagerBean;
    static /* synthetic */ Class class$com$opensymphony$module$access$provider$ejb$OsAclHome;
    static /* synthetic */ Class class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome;

    public void ejbCreate() throws CreateException {
    }

    public void ejbRemove() {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    public MessageBean createAcl(String realm, String key, String username, String groupname, String availAccess) {
        MessageBean message = new MessageBean();
        message.setError(false);
        if (realm == null || key == null || availAccess == null) {
            message.setError(true);
            message.setMessage("data was null");
            return message;
        }
        if (groupname == null && username == null) {
            message.setError(true);
            message.setMessage("groupname and username are null");
            return message;
        }
        if (realm.trim().length() == 0 || key.trim().length() == 0 || availAccess.trim().length() == 0) {
            message.setError(true);
            message.setMessage("data has zero length");
            return message;
        }
        if (groupname == null) {
            groupname = "";
        }
        if (username == null) {
            username = "";
        }
        this.accessManager_ = AccessManager.getInstance();
        logger.debug((Object)("create Acl for " + realm + " with key: " + key + ", username: \"" + username + "\", groupname: \"" + groupname + "\""));
        if (groupname.trim().length() != 0) {
            try {
                this.accessManager_.createGroupAccessLevel(realm, groupname, key, availAccess);
                logger.debug((Object)("success: created Group-Acl for " + realm + " for resource : " + key + " group: " + groupname));
                message.setError(false);
                message.setMessage("created Group-Acl for " + realm + " for resource : " + key + " group: " + groupname);
                return message;
            }
            catch (ImmutableException ex) {
                logger.fatal((Object)("cannot create Group-Acl for realm " + realm + " : " + ex));
                message.setError(true);
                message.setMessage("cannot create Group-Acl for realm " + realm + " : " + ex);
                return message;
            }
            catch (NotFoundException ex) {
                logger.fatal((Object)"group does not exists ");
                message.setError(true);
                message.setMessage("group does not exists ");
                return message;
            }
        }
        if (username.trim().length() != 0) {
            try {
                this.accessManager_.createUserAccessLevel(realm, username, key, availAccess);
                logger.debug((Object)("success: created User-Acl for " + realm + " for resource : " + key + " user: " + username));
                message.setError(false);
                message.setMessage("created User-Acl for " + realm + " for resource : " + key + " user: " + username);
                return message;
            }
            catch (DuplicateKeyException ex) {
                logger.fatal((Object)("Acl exists already for realm " + realm));
                message.setError(true);
                message.setMessage("Acl exists already for realm " + realm);
                return message;
            }
            catch (ImmutableException ex) {
                logger.fatal((Object)("cannot create User-Acl for realm " + realm + " " + ex));
                message.setError(true);
                message.setMessage("cannot create User-Acl for realm " + realm + " " + ex);
                return message;
            }
            catch (NotFoundException ex) {
                logger.fatal((Object)"user does not exists ");
                message.setError(true);
                message.setMessage("user does not exists ");
                return message;
            }
        }
        logger.fatal((Object)("Error: could not create Acl with received data, application: " + realm + ", key: " + key + ", username: " + username + ", groupname: " + groupname + ", accessLevel: " + availAccess));
        message.setError(true);
        message.setMessage("Error: could not create Acl with received data, application: " + realm + ", key: " + key + ", username: \"" + username + "\", groupname: \"" + groupname + "\", accessLevel: " + availAccess);
        return message;
    }

    public boolean deleteAclOfUser(String realm, String key, String User2) {
        if (realm == null || key == null || User2 == null) {
            return false;
        }
        if (realm.trim().length() == 0 || key.trim().length() == 0 || User2.trim().length() == 0) {
            return false;
        }
        logger.debug((Object)"delete User Acl");
        this.accessManager_ = AccessManager.getInstance();
        try {
            this.accessManager_.deleteUserAccessLevel(realm, User2, key);
            return true;
        }
        catch (NotFoundException ex) {
            logger.fatal((Object)("Acl not found in realm :" + realm + ", with key :" + key + ", user :" + User2));
            return false;
        }
        catch (ImmutableException ex) {
            logger.fatal((Object)("Acl not delete in realm " + realm + " with key " + key + " user " + User2));
            return false;
        }
    }

    public Vector getAllAclOfRealm(String realm) {
        if (realm == null) {
            return null;
        }
        if (realm.trim().length() == 0) {
            return null;
        }
        this.accessManager_ = AccessManager.getInstance();
        logger.debug((Object)("getAllAclOfRealm of Realm: " + realm));
        Vector<AclVO> aclList = new Vector<AclVO>();
        try {
            ArrayList list = this.accessManager_.getAcls(realm);
            if (list == null) {
                return null;
            }
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                AclEntity entity = (AclEntity)iter.next();
                aclList.add(AclVOFactory.getData(realm, entity));
                AclVO vo = AclVOFactory.getData(realm, entity);
            }
            return aclList;
        }
        catch (NotFoundException ex) {
            logger.error((Object)"realm not found");
            return null;
        }
    }

    public Vector getAllAclByResourcesKey(String key) {
        if (key == null) {
            return null;
        }
        if (key.trim().length() == 0) {
            return null;
        }
        this.accessManager_ = AccessManager.getInstance();
        logger.debug((Object)("getAllAclByResourcesKey " + key));
        Vector appList = this.getAllApplications();
        if (appList == null) {
            return null;
        }
        Vector<AclVO> result = new Vector<AclVO>();
        Iterator apps = appList.iterator();
        while (apps.hasNext()) {
            String realm = (String)apps.next();
            try {
                ArrayList list = this.accessManager_.getAclsByResource(key);
                if (list == null) continue;
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    AclEntity entity = (AclEntity)iter.next();
                    result.add(AclVOFactory.getData(realm, entity));
                }
            }
            catch (NotFoundException ex) {
                logger.error((Object)"acl not found");
            }
        }
        return result;
    }

    public Vector getAllAclOfRealmOfGroup(String realm, String groupname) {
        if (realm == null || groupname == null) {
            return null;
        }
        if (realm.trim().length() == 0 || groupname.trim().length() == 0) {
            return null;
        }
        this.accessManager_ = AccessManager.getInstance();
        logger.debug((Object)("getAllAclOfRealmOfGroup " + realm + " " + groupname));
        Vector<AclVO> result = new Vector<AclVO>();
        try {
            ArrayList list = this.accessManager_.getAclsByGroup(realm, groupname);
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                AclEntity entity = (AclEntity)iter.next();
                logger.debug((Object)("found for group " + groupname + ", resource: " + entity.getResourceKey()));
                result.add(AclVOFactory.getData(realm, entity));
            }
            return result;
        }
        catch (NotFoundException ex) {
            logger.error((Object)"acl not found");
            return null;
        }
    }

    public Vector getAllAclOfRealmOfUser(String realm, String username) {
        if (realm == null || username == null) {
            return null;
        }
        if (realm.trim().length() == 0 || username.trim().length() == 0) {
            return null;
        }
        this.accessManager_ = AccessManager.getInstance();
        logger.debug((Object)("getAllAclOfRealmOfUser " + realm + " " + username));
        Vector<AclVO> result = new Vector<AclVO>();
        try {
            ArrayList list = this.accessManager_.getAclsByUser(realm, username);
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                AclEntity entity = (AclEntity)iter.next();
                logger.debug((Object)("found for user " + username + " resource: " + entity.getResourceKey()));
                result.add(AclVOFactory.getData(realm, entity));
            }
            return result;
        }
        catch (NotFoundException ex) {
            logger.error((Object)"acl not found");
            return null;
        }
    }

    private Vector getAllApplications() {
        Vector<String> list = new Vector<String>();
        logger.debug((Object)"return application-List");
        Vector v = new Vector(this.accessManager_.getResourceProviders());
        Iterator iter = v.iterator();
        while (iter.hasNext()) {
            String realm = ((BaseProvider)iter.next()).getRealm();
            logger.debug((Object)("add " + realm));
            list.add(realm);
        }
        return list;
    }

    public boolean deleteAclOfGroup(String realm, String key, String group) {
        if (realm == null || key == null || group == null) {
            return false;
        }
        if (realm.trim().length() == 0 || key.trim().length() == 0 || group.trim().length() == 0) {
            return false;
        }
        logger.debug((Object)"delete Group Acl");
        this.accessManager_ = AccessManager.getInstance();
        try {
            this.accessManager_.deleteGroupAccessLevel(realm, group, key);
            return true;
        }
        catch (NotFoundException ex) {
            logger.fatal((Object)("Acl not found in realm " + realm + " with key " + key + " group " + group));
            return false;
        }
        catch (ImmutableException ex) {
            logger.fatal((Object)("Acl not delete in realm " + realm + " with key " + key + " group " + group));
            return false;
        }
    }

    public boolean deleteAclByRealmAndResourceKey(String realm, String resourceKey) {
        if (realm == null || resourceKey == null) {
            return false;
        }
        if (realm.trim().length() == 0 || resourceKey.trim().length() == 0) {
            return false;
        }
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("Acl");
            OsAcl acl = null;
            OsAclHome home = (OsAclHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsAclHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsAclHome = AclManagerBean.class$("com.opensymphony.module.access.provider.ejb.OsAclHome")) : class$com$opensymphony$module$access$provider$ejb$OsAclHome));
            Vector aclToDelete = new Vector(home.findByRealmAndResourceKey(realm, resourceKey));
            Iterator iter = aclToDelete.iterator();
            if (iter.hasNext()) {
                acl = (OsAcl)iter.next();
                try {
                    acl.remove();
                    return true;
                }
                catch (RemoveException ex) {
                    return false;
                }
                catch (EJBException ex) {
                    return false;
                }
            }
            return true;
        }
        catch (FinderException ex) {
            logger.error((Object)ex.toString());
            return true;
        }
        catch (ClassCastException ex) {
            logger.error((Object)ex.toString());
            return false;
        }
        catch (NamingException ex) {
            logger.error((Object)ex.toString());
            return false;
        }
    }

    public AclVO getAclByID(Long id) {
        if (id == null) {
            return null;
        }
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("Acl");
            OsAclHome home = (OsAclHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsAclHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsAclHome = AclManagerBean.class$("com.opensymphony.module.access.provider.ejb.OsAclHome")) : class$com$opensymphony$module$access$provider$ejb$OsAclHome));
            OsAcl acl = null;
            acl = home.findByPrimaryKey(id);
            return AclVOFactory.getData(acl.getRealm(), new AclEntity(acl));
        }
        catch (FinderException ex) {
            logger.error((Object)ex.toString());
            return null;
        }
        catch (ClassCastException ex) {
            logger.error((Object)ex.toString());
            return null;
        }
        catch (NamingException ex) {
            logger.error((Object)ex.toString());
            return null;
        }
        catch (Exception ex) {
            logger.error((Object)ex.toString());
            return null;
        }
    }

    public boolean updateAcl(Long id, String accessLevel) {
        if (id == null || accessLevel == null) {
            return false;
        }
        if (accessLevel.trim().length() == 0 || id < 0L) {
            return false;
        }
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("Acl");
            OsAclHome home = (OsAclHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsAclHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsAclHome = AclManagerBean.class$("com.opensymphony.module.access.provider.ejb.OsAclHome")) : class$com$opensymphony$module$access$provider$ejb$OsAclHome));
            OsAcl acl = home.findByPrimaryKey(id);
            acl.setAccessLevel(accessLevel);
            return true;
        }
        catch (Exception ex) {
            logger.error((Object)ex.toString());
            return false;
        }
    }

    public AclVO getAclByRealmAndResourceKeyAndUser(String realm, String key, String user) {
        if (realm == null || key == null || user == null) {
            return null;
        }
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("Acl");
            OsAclHome home = (OsAclHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsAclHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsAclHome = AclManagerBean.class$("com.opensymphony.module.access.provider.ejb.OsAclHome")) : class$com$opensymphony$module$access$provider$ejb$OsAclHome));
            OsAcl acl = home.findByRealmAndResourceKeyAndUserId(realm, key, user);
            return AclVOFactory.getData(acl.getRealm(), new AclEntity(acl));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public AclVO getAclByRealmAndResourceKeyAndGroup(String realm, String key, String group) {
        if (realm == null || key == null || group == null) {
            return null;
        }
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("Acl");
            OsAclHome home = (OsAclHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsAclHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsAclHome = AclManagerBean.class$("com.opensymphony.module.access.provider.ejb.OsAclHome")) : class$com$opensymphony$module$access$provider$ejb$OsAclHome));
            OsAcl acl = home.findByRealmAndGroupIdAndResourceKey(realm, group, key);
            return AclVOFactory.getData(acl.getRealm(), new AclEntity(acl));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public boolean deleteAclById(Long id) {
        if (id == null) {
            return false;
        }
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("Acl");
            OsAclHome home = (OsAclHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsAclHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsAclHome = AclManagerBean.class$("com.opensymphony.module.access.provider.ejb.OsAclHome")) : class$com$opensymphony$module$access$provider$ejb$OsAclHome));
            OsAcl acl = home.findByPrimaryKey(id);
            acl.remove();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public String exportAcls(String realm, String filename) {
        Vector<AclVO> groupAcls = new Vector<AclVO>();
        Vector<SmallGroupVO> groups = new Vector<SmallGroupVO>();
        Vector<ResourceVO> resources = new Vector<ResourceVO>();
        try {
            Vector aclsOfRealm = this.getAllAclOfRealm(realm);
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("OsGroupInRealm");
            OsGroupInRealmHome home = (OsGroupInRealmHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome = AclManagerBean.class$("com.opensymphony.module.access.provider.ejb.OsGroupInRealmHome")) : class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome));
            int i = 0;
            while (i != aclsOfRealm.size()) {
                AclVO vo = (AclVO)aclsOfRealm.get(i);
                if (vo.getGroupId() != null && vo.getGroupId().length() > 0) {
                    groupAcls.add(vo);
                    SmallGroupVO groupVO = SmallGroupVOFactory.getData(home.findGroupInRealm(vo.getGroupId(), realm));
                    boolean exists = false;
                    int j = 0;
                    while (j != groups.size()) {
                        if (groupVO.getName().equalsIgnoreCase(((SmallGroupVO)groups.get(j)).getName())) {
                            exists = true;
                        }
                        ++j;
                    }
                    if (!exists) {
                        groups.add(groupVO);
                    }
                    exists = false;
                }
                ++i;
            }
            this.accessManager_ = AccessManager.getInstance();
            ArrayList list = this.accessManager_.getResources(realm);
            int i2 = 0;
            while (i2 != list.size()) {
                resources.add(ResourceVOFactory.getData(realm, (ResourceEntity)list.get(i2)));
                ++i2;
            }
            AclXMLGenerator exportXML = new AclXMLGenerator(realm, groups, resources, groupAcls);
            XMLFileWriter.writeXMLFile(filename, exportXML.getDocument());
        }
        catch (NotFoundException anf) {
            anf.printStackTrace();
            anf.getMessage();
        }
        catch (ParserConfigurationException pex) {
            pex.printStackTrace();
            return pex.getMessage();
        }
        catch (TransformerConfigurationException tcx) {
            tcx.printStackTrace();
            return tcx.getMessage();
        }
        catch (TransformerException tex) {
            tex.printStackTrace();
            return tex.getMessage();
        }
        catch (FinderException fex) {
            fex.printStackTrace();
            return fex.getMessage();
        }
        catch (IOException iox) {
            iox.printStackTrace();
        }
        catch (NamingException nex) {
            nex.printStackTrace();
            return nex.getMessage();
        }
        return null;
    }

    public AclImportVO importAclsFile(String realm, String filename) throws SAXException {
        File file = new File(filename);
        XMLFileLoader loader = new XMLFileLoader(file);
        AclParser parser = new AclParser(loader.getDocument());
        return parser.getAclImportVO();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

