/*
 * Decompiled with CFR 0.152.
 */
package server.Management.group;

import at.tugraz.genome.usermanagement.server.application.VO.ApplicationVO;
import at.tugraz.genome.usermanagement.server.group.VO.SmallGroupVO;
import at.tugraz.genome.usermanagement.server.user.VO.ExtendedUserVO;
import at.tugraz.genome.usermanagement.server.user.VOFactory.ExtendedUserVOFactory;
import at.tugraz.genome.usermanagement.server.user.cache.ExtendedUserVOCache;
import at.tugraz.genome.util.GeneralComparator;
import com.opensymphony.module.access.AccessManager;
import com.opensymphony.module.access.provider.BaseProvider;
import com.opensymphony.module.access.provider.ejb.OsAcl;
import com.opensymphony.module.access.provider.ejb.OsAclHome;
import com.opensymphony.module.access.provider.ejb.OsAdminsgroup;
import com.opensymphony.module.access.provider.ejb.OsAdminsgroupHome;
import com.opensymphony.module.access.provider.ejb.OsGroupInRealm;
import com.opensymphony.module.access.provider.ejb.OsGroupInRealmHome;
import com.opensymphony.module.user.DuplicateEntityException;
import com.opensymphony.module.user.EntityNotFoundException;
import com.opensymphony.module.user.Group;
import com.opensymphony.module.user.ImmutableException;
import com.opensymphony.module.user.User;
import com.opensymphony.module.user.UserManager;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import server.Management.application.ApplicationManager;
import server.Management.application.ApplicationManagerHome;
import server.Management.group.VOFactory.SmallGroupVOFactory;
import server.Management.util.FilterDoubleEntries;

public class GroupManagementBean
implements SessionBean {
    SessionContext sessionContext;
    private static final Log logger = LogFactory.getLog((Class)(class$server$Management$group$GroupManagementBean == null ? (class$server$Management$group$GroupManagementBean = GroupManagementBean.class$("server.Management.group.GroupManagementBean")) : class$server$Management$group$GroupManagementBean));
    private UserManager userManager_;
    private AccessManager accessManager_;
    static /* synthetic */ Class class$server$Management$group$GroupManagementBean;
    static /* synthetic */ Class class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome;
    static /* synthetic */ Class class$com$opensymphony$module$access$provider$ejb$OsAdminsgroupHome;
    static /* synthetic */ Class class$com$opensymphony$module$access$provider$ejb$OsAclHome;
    static /* synthetic */ Class class$server$Management$application$ApplicationManagerHome;

    public void ejbCreate() throws CreateException {
        this.userManager_ = UserManager.getInstance();
        this.accessManager_ = AccessManager.getInstance();
    }

    public void ejbRemove() {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    public Vector getAllGroups() {
        logger.info((Object)"getAllGroups");
        Vector<SmallGroupVO> groupList = new Vector<SmallGroupVO>();
        List groups = null;
        try {
            if (this.userManager_ == null) {
                return null;
            }
            groups = this.userManager_.getGroups();
            Iterator iterator = groups.iterator();
            while (iterator.hasNext()) {
                Group group = (Group)iterator.next();
                groupList.add(SmallGroupVOFactory.getData(group.getName()));
            }
            Collections.sort(groupList, new GeneralComparator("at.tugraz.genome.usermanagement.server.group.VO.SmallGroupVO", "getName", "java.lang.String"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return groupList;
    }

    public boolean createGroup(String groupname) throws DuplicateEntityException {
        logger.info((Object)("createGroup " + groupname));
        if (groupname == null) {
            return false;
        }
        if (groupname.trim().length() == 0) {
            return false;
        }
        this.userManager_ = UserManager.getInstance();
        try {
            this.userManager_.createGroup(groupname);
            logger.debug((Object)("group " + groupname + " successfully created"));
            return true;
        }
        catch (DuplicateEntityException ex) {
            logger.error((Object)"group already defined");
            throw new DuplicateEntityException("group already exists");
        }
        catch (ImmutableException ex) {
            return false;
        }
    }

    public boolean deleteGroup(String groupname) {
        logger.info((Object)("deleteGroup " + groupname));
        if (groupname != null && groupname.trim().length() == 0) {
            return false;
        }
        this.userManager_ = UserManager.getInstance();
        this.accessManager_ = AccessManager.getInstance();
        try {
            Iterator iter;
            Object home;
            Object ref;
            InitialContext ctx;
            Group group = this.userManager_.getGroup(groupname);
            try {
                ctx = new InitialContext();
                ref = ctx.lookup("OsGroupInRealm");
                home = (OsGroupInRealmHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome = GroupManagementBean.class$("com.opensymphony.module.access.provider.ejb.OsGroupInRealmHome")) : class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome));
                Vector realms = new Vector(home.findAllRealmsOfGroup(groupname));
                iter = realms.iterator();
                while (iter.hasNext()) {
                    OsGroupInRealm os = (OsGroupInRealm)iter.next();
                    logger.debug((Object)("deleted OsGroupInRealm of realm " + os.getRealm()));
                    os.remove();
                }
                Object adminRef = ctx.lookup("OsAdminsgroup");
                OsAdminsgroupHome adminHome = (OsAdminsgroupHome)PortableRemoteObject.narrow((Object)adminRef, (Class)(class$com$opensymphony$module$access$provider$ejb$OsAdminsgroupHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsAdminsgroupHome = GroupManagementBean.class$("com.opensymphony.module.access.provider.ejb.OsAdminsgroupHome")) : class$com$opensymphony$module$access$provider$ejb$OsAdminsgroupHome));
                Collection admingroup = adminHome.findByGroup(groupname);
                iter = admingroup.iterator();
                while (iter.hasNext()) {
                    OsAdminsgroup os = (OsAdminsgroup)iter.next();
                    logger.debug((Object)("deleted OsAdminsgroup of realm " + os.getRealm()));
                    os.remove();
                }
            }
            catch (RemoveException ex) {
            }
            catch (EJBException ex) {
            }
            catch (FinderException ex) {
                logger.error((Object)ex);
            }
            catch (NamingException ex) {
                // empty catch block
            }
            try {
                ctx = new InitialContext();
                ref = ctx.lookup("Acl");
                home = (OsAclHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsAclHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsAclHome = GroupManagementBean.class$("com.opensymphony.module.access.provider.ejb.OsAclHome")) : class$com$opensymphony$module$access$provider$ejb$OsAclHome));
                Vector acls = new Vector(home.findByGroup(groupname));
                iter = acls.iterator();
                while (iter.hasNext()) {
                    OsAcl acl = (OsAcl)iter.next();
                    logger.debug((Object)("deleted Acls of realm " + acl.getRealm()));
                    acl.remove();
                }
            }
            catch (RemoveException ex) {
                logger.error((Object)ex);
            }
            catch (EJBException ex) {
                logger.error((Object)ex);
            }
            catch (FinderException ex) {
                logger.error((Object)ex);
            }
            catch (NamingException ex) {
                // empty catch block
            }
            group.remove();
            logger.debug((Object)"removed group successfully");
            this.updateAllUsersInCache();
            return true;
        }
        catch (EntityNotFoundException ex) {
            logger.error((Object)"group does not exist");
            return true;
        }
        catch (ImmutableException ex) {
            return false;
        }
    }

    public boolean addUserToGroup(String username, String groupname) {
        logger.info((Object)("addUserToGroup " + groupname + " " + username));
        if (groupname == null || groupname == null) {
            return false;
        }
        if (groupname.trim().length() == 0) {
            return false;
        }
        if (username.trim().length() == 0) {
            return false;
        }
        logger.debug((Object)("will add user: " + username + " to group " + groupname));
        this.userManager_ = UserManager.getInstance();
        Group destGroup = null;
        User userToAdd = null;
        try {
            destGroup = this.userManager_.getGroup(groupname);
        }
        catch (EntityNotFoundException ex) {
            logger.error((Object)("group does not exist " + ex.getMessage()));
            return false;
        }
        try {
            userToAdd = this.userManager_.getUser(username);
        }
        catch (EntityNotFoundException ex) {
            logger.error((Object)("user does not exist " + ex.getMessage()));
            return false;
        }
        logger.debug((Object)("will now add user: " + username + " to group " + groupname));
        destGroup.addUser(userToAdd);
        ExtendedUserVOCache.getInstance().updateUser(username);
        return true;
    }

    public boolean deleteUserFromGroup(String username, String groupname) {
        logger.info((Object)("deleteUserFromGroup " + groupname + " " + username));
        if (groupname.trim().length() == 0) {
            return false;
        }
        if (username.trim().length() == 0) {
            return false;
        }
        this.userManager_ = UserManager.getInstance();
        Group destGroup = null;
        User userToDelete = null;
        try {
            destGroup = this.userManager_.getGroup(groupname);
        }
        catch (EntityNotFoundException ex) {
            logger.error((Object)("group does not exist " + ex.getMessage()));
            return false;
        }
        try {
            userToDelete = this.userManager_.getUser(username);
        }
        catch (EntityNotFoundException ex) {
            logger.error((Object)("user does not exist " + ex.getMessage()));
            return false;
        }
        destGroup.removeUser(userToDelete);
        ExtendedUserVOCache.getInstance().updateUser(username);
        return true;
    }

    public Vector getAllGroupsOfUser(String username) {
        logger.info((Object)("getAllGroupsOfUser " + username));
        if (username.trim().length() == 0) {
            return null;
        }
        this.userManager_ = UserManager.getInstance();
        User user = null;
        Vector<SmallGroupVO> listOfGroups = new Vector<SmallGroupVO>();
        try {
            user = this.userManager_.getUser(username);
        }
        catch (EntityNotFoundException ex) {
            logger.error((Object)("user not found " + ex.getMessage()));
            return null;
        }
        List tmp = user.getGroups();
        Iterator iter = tmp.iterator();
        while (iter.hasNext()) {
            listOfGroups.add(SmallGroupVOFactory.getData(((SmallGroupVO)iter.next()).getName()));
        }
        Collections.sort(listOfGroups, new GeneralComparator("at.tugraz.genome.usermanagement.server.group.VO.SmallGroupVO", "getName", "java.lang.String"));
        return listOfGroups;
    }

    public Vector getAllUsersOfGroup(String groupname) {
        logger.info((Object)("getAllUsersOfGroup " + groupname));
        if (groupname == null) {
            return null;
        }
        if (groupname.trim().length() == 0) {
            return null;
        }
        this.userManager_ = UserManager.getInstance();
        Group group = null;
        Vector<ExtendedUserVO> listOfUsers = new Vector<ExtendedUserVO>();
        try {
            group = this.userManager_.getGroup(groupname);
        }
        catch (EntityNotFoundException ex) {
            logger.error((Object)("group not found " + ex.getMessage()));
            return null;
        }
        List list = group.getUsers();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            String user = (String)iter.next();
            listOfUsers.add(ExtendedUserVOFactory.getUserVO(user, false));
        }
        Collections.sort(listOfUsers, new GeneralComparator("at.tugraz.genome.usermanagement.server.user.VO.ExtendedUserVO", "getName", "java.lang.String"));
        return listOfUsers;
    }

    public Vector getApplicationsGroupIsEnabled(String groupname) {
        logger.info((Object)("getApplicationsGroupIsEnabled " + groupname));
        if (groupname == null) {
            return null;
        }
        if (groupname.trim().length() == 0) {
            return null;
        }
        Vector<ApplicationVO> result = new Vector<ApplicationVO>();
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("OsGroupInRealm");
            OsGroupInRealmHome home = (OsGroupInRealmHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome = GroupManagementBean.class$("com.opensymphony.module.access.provider.ejb.OsGroupInRealmHome")) : class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome));
            Vector realms = new Vector(home.findAllRealmsOfGroup(groupname));
            Iterator iter = realms.iterator();
            while (iter.hasNext()) {
                OsGroupInRealm osGroup = (OsGroupInRealm)iter.next();
                result.add(new ApplicationVO(osGroup.getRealm()));
            }
            Collections.sort(result, new GeneralComparator("at.tugraz.genome.usermanagement.server.application.VO.ApplicationVO", "getApplicationname", "java.lang.String"));
            logger.debug((Object)("found " + realms.size() + " of applications, group is enabled"));
            return result;
        }
        catch (NamingException ex) {
        }
        catch (EJBException ex) {
        }
        catch (FinderException ex) {
            logger.error((Object)ex);
        }
        return null;
    }

    public SmallGroupVO getGroup(String groupname, String realm) {
        logger.info((Object)("getGroup " + groupname));
        if (realm == null || groupname == null) {
            return null;
        }
        logger.debug((Object)("getGroup : " + groupname));
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("OsGroupInRealm");
            OsGroupInRealmHome home = (OsGroupInRealmHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome = GroupManagementBean.class$("com.opensymphony.module.access.provider.ejb.OsGroupInRealmHome")) : class$com$opensymphony$module$access$provider$ejb$OsGroupInRealmHome));
            OsGroupInRealm group = home.findGroupInRealm(groupname, realm);
            return SmallGroupVOFactory.getData(group);
        }
        catch (NamingException ex) {
            logger.error((Object)("could not find bean " + ex));
        }
        catch (FinderException ex) {
            logger.error((Object)("could not find realm " + (Object)((Object)ex)));
        }
        return null;
    }

    public boolean setGrouptoAdminstrator(String groupname, String realm) {
        logger.info((Object)("setGrouptoAdminstrator " + groupname));
        if (realm == null || groupname == null) {
            return false;
        }
        logger.debug((Object)("setGrouptoAdminstrator : " + groupname + ", realm: " + realm));
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("OsAdminsgroup");
            OsAdminsgroupHome home = (OsAdminsgroupHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsAdminsgroupHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsAdminsgroupHome = GroupManagementBean.class$("com.opensymphony.module.access.provider.ejb.OsAdminsgroupHome")) : class$com$opensymphony$module$access$provider$ejb$OsAdminsgroupHome));
            try {
                home.findByRealmAndGroupname(groupname, realm);
                logger.debug((Object)"group already set to admin group");
            }
            catch (FinderException ex1) {
                try {
                    home.create(realm, groupname);
                    logger.debug((Object)"group get to admin group");
                }
                catch (CreateException ex2) {
                    return false;
                }
            }
            return true;
        }
        catch (ClassCastException ex) {
            logger.error((Object)ex);
        }
        catch (NamingException ex) {
            logger.error((Object)ex);
        }
        return false;
    }

    public boolean unsetGrouptoAdminstrator(String groupname, String realm) {
        logger.info((Object)("unsetGrouptoAdminstrator " + groupname));
        if (realm == null || groupname == null) {
            return false;
        }
        logger.debug((Object)("unsetGrouptoAdminstrator : " + groupname + ", realm: " + realm));
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("OsAdminsgroup");
            OsAdminsgroupHome home = (OsAdminsgroupHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsAdminsgroupHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsAdminsgroupHome = GroupManagementBean.class$("com.opensymphony.module.access.provider.ejb.OsAdminsgroupHome")) : class$com$opensymphony$module$access$provider$ejb$OsAdminsgroupHome));
            OsAdminsgroup admingroup = home.findByRealmAndGroupname(groupname, realm);
            admingroup.remove();
            return true;
        }
        catch (FinderException ex) {
            logger.error((Object)ex);
        }
        catch (RemoveException ex) {
            logger.error((Object)ex);
        }
        catch (ClassCastException ex) {
            logger.error((Object)ex);
        }
        catch (NamingException ex) {
            logger.error((Object)ex);
        }
        return false;
    }

    public boolean isGroupAdmin(String groupname, String realm) {
        logger.info((Object)("isGroupAdmin " + groupname));
        if (realm == null || groupname == null) {
            return false;
        }
        logger.debug((Object)("isGroupAdmin : " + groupname + ", realm: " + realm));
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("OsAdminsgroup");
            OsAdminsgroupHome home = (OsAdminsgroupHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$OsAdminsgroupHome == null ? (class$com$opensymphony$module$access$provider$ejb$OsAdminsgroupHome = GroupManagementBean.class$("com.opensymphony.module.access.provider.ejb.OsAdminsgroupHome")) : class$com$opensymphony$module$access$provider$ejb$OsAdminsgroupHome));
            OsAdminsgroup admingroup = home.findByRealmAndGroupname(realm, groupname);
            return true;
        }
        catch (FinderException ex) {
            return false;
        }
        catch (ClassCastException ex) {
            return false;
        }
        catch (NamingException ex) {
            return false;
        }
    }

    private void updateAllUsersInCache() {
        logger.info((Object)"updateAllUsersInCache ");
        UserManager userManager_ = UserManager.getInstance();
        List userList = userManager_.getUsers();
        Iterator iter = userList.iterator();
        logger.debug((Object)"got all users");
        while (iter.hasNext()) {
            User user = (User)iter.next();
            ExtendedUserVOCache.getInstance().updateUser(user.getName());
            logger.info((Object)("updated ExtendedUserVO of user \"" + user.getName()));
        }
    }

    public boolean isUserAdminOfGroup(String adminUsername, String groupname) {
        logger.info((Object)("isUserAdminOfGroup " + adminUsername + " " + groupname));
        ApplicationManager appManager = null;
        Vector allGroupsOfAdmin = new Vector();
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("ApplicationManager");
            ApplicationManagerHome applicationManagerHome = (ApplicationManagerHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$server$Management$application$ApplicationManagerHome == null ? (class$server$Management$application$ApplicationManagerHome = GroupManagementBean.class$("server.Management.application.ApplicationManagerHome")) : class$server$Management$application$ApplicationManagerHome));
            appManager = applicationManagerHome.create();
        }
        catch (RemoteException ex) {
            logger.error((Object)ex);
            return false;
        }
        catch (CreateException ex) {
            logger.error((Object)ex);
            return false;
        }
        catch (ClassCastException ex) {
            logger.error((Object)ex);
            return false;
        }
        catch (NamingException ex) {
            logger.error((Object)ex);
            return false;
        }
        this.accessManager_ = AccessManager.getInstance();
        Vector<ApplicationVO> realmsTheUserIsAmdin = new Vector<ApplicationVO>();
        logger.debug((Object)"return application-List");
        Vector v = new Vector(this.accessManager_.getResourceProviders());
        Iterator iter = v.iterator();
        while (iter.hasNext()) {
            String realm = ((BaseProvider)iter.next()).getRealm();
            logger.debug((Object)("add " + realm));
            if (appManager == null) continue;
            try {
                if (!appManager.isAdminOfRealm(realm, adminUsername)) continue;
                realmsTheUserIsAmdin.add(new ApplicationVO(realm));
                allGroupsOfAdmin.addAll(appManager.getAllGroupsEnabledInApplication(realm));
            }
            catch (RemoteException ex1) {
                logger.error((Object)ex1);
                return false;
            }
        }
        return (allGroupsOfAdmin = FilterDoubleEntries.filterGroups(allGroupsOfAdmin)).contains(new SmallGroupVO(groupname));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

