/*
 * Decompiled with CFR 0.152.
 */
package server.Management.rights.authentication.token;

import com.opensymphony.module.user.EntityNotFoundException;
import com.opensymphony.module.user.User;
import java.sql.Timestamp;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import server.Management.Management;
import server.Management.rights.authentication.exception.TokenException;
import server.Management.rights.authentication.token.AuthToken;

public class DateToken
extends Management
implements AuthToken {
    private String errorMsg_;
    private String username_;
    private Timestamp stamp_;
    private String key_;
    private boolean result_;
    private String action_;
    private User user_;
    private static final Log logger_ = LogFactory.getLog((Class)(class$server$Management$rights$authentication$token$DateToken == null ? (class$server$Management$rights$authentication$token$DateToken = DateToken.class$("server.Management.rights.authentication.token.DateToken")) : class$server$Management$rights$authentication$token$DateToken));
    static /* synthetic */ Class class$server$Management$rights$authentication$token$DateToken;

    public void initalize(Element element, Object username, Object input) throws TokenException {
        this.stamp_ = new Timestamp(System.currentTimeMillis());
        this.username_ = (String)username;
        NodeList childNodes = element.getChildNodes();
        this.userManager_ = this.getUserManager();
        try {
            this.user_ = this.userManager_.getUser(this.username_);
        }
        catch (EntityNotFoundException ex) {
            logger_.error((Object)ex);
        }
        if (childNodes.getLength() == 1) {
            Node node = childNodes.item(0);
            if (node.hasAttributes()) {
                this.action_ = node.getNodeName();
                if (((Element)node).getAttribute("result").equals("true")) {
                    this.result_ = true;
                } else if (((Element)node).getAttribute("result").equals("false")) {
                    this.result_ = false;
                } else {
                    throw new TokenException("Invalid Result of this Token");
                }
                this.key_ = ((CharacterData)node.getFirstChild()).getData();
            }
        } else {
            throw new TokenException("Action:: exactly one action allowed");
        }
    }

    public boolean isGreater() throws TokenException {
        Long date = this.user_.getPropertySet().getDate(this.key_);
        if (date == null) {
            throw new TokenException("no date for user available");
        }
        Timestamp stamp = new Timestamp(date);
        boolean result = stamp.after(this.stamp_);
        return result;
    }

    public boolean isLower() throws TokenException {
        Long date = this.user_.getPropertySet().getDate(this.key_);
        Timestamp stamp = new Timestamp(date);
        boolean result = stamp.before(this.stamp_);
        return result;
    }

    public boolean isEqual() throws TokenException {
        Long date = this.user_.getPropertySet().getDate(this.key_);
        Timestamp stamp = new Timestamp(date);
        return stamp.equals(this.stamp_);
    }

    public boolean contains() throws TokenException {
        throw new TokenException("Not supported by this Token");
    }

    public String toString() {
        return "Date Action: " + this.action_ + ", Result must be: " + this.result_ + ", with Key: " + this.key_;
    }

    public boolean makeAuthentication() throws TokenException {
        boolean res = false;
        if (this.action_.equals("isEqual")) {
            boolean bl = res = !(this.result_ ^ this.isEqual());
            if (!res) {
                this.errorMsg_ = "account don't match with date";
            }
            return res;
        }
        if (this.action_.equals("isLower")) {
            boolean bl = res = !(this.result_ ^ this.isLower());
            if (!res) {
                this.errorMsg_ = "account will start in future";
            }
            return res;
        }
        if (this.action_.trim().equals("isGreater")) {
            boolean bl = res = !(this.result_ ^ this.isGreater());
            if (!res) {
                this.errorMsg_ = "account expired";
            }
            return res;
        }
        if (this.action_.equals("contains")) {
            boolean bl = res = !(this.result_ ^ this.contains());
            if (!res) {
                this.errorMsg_ = "account contains wrong date";
            }
            return res;
        }
        this.errorMsg_ = "date token wrong";
        return false;
    }

    public String getErrorMessage() {
        return this.errorMsg_;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

