/*
 * Decompiled with CFR 0.152.
 */
package server.Management.rights.authentication.token;

import com.opensymphony.module.user.EntityNotFoundException;
import com.opensymphony.module.user.User;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import server.Management.Management;
import server.Management.rights.authentication.exception.TokenException;
import server.Management.rights.authentication.token.AuthToken;

public class PasswordToken
extends Management
implements AuthToken {
    private String errorMsg_;
    private String username_;
    private String passwordFromUser_;
    private String key_;
    private boolean result_;
    private String action_;
    private User user_;
    private static final String ERROR_MESSAGE = "username or password wrong";

    public void initalize(Element element, Object username, Object input) throws TokenException {
        this.passwordFromUser_ = (String)input;
        this.username_ = (String)username;
        NodeList childNodes = element.getChildNodes();
        this.userManager_ = this.getUserManager();
        if (childNodes.getLength() == 1) {
            Node node = childNodes.item(0);
            if (node.hasAttributes()) {
                this.action_ = node.getNodeName();
                if (((Element)node).getAttribute("result").equals("true")) {
                    this.result_ = true;
                } else if (((Element)node).getAttribute("result").equals("false")) {
                    this.result_ = false;
                } else {
                    throw new TokenException("Invalid Result of this Token");
                }
                this.key_ = ((CharacterData)node.getFirstChild()).getData();
            }
        } else {
            throw new TokenException("Action:: exactly one action allowed");
        }
    }

    public boolean isGreater() throws TokenException {
        throw new TokenException("Not supported by this Token");
    }

    public boolean isLower() throws TokenException {
        throw new TokenException("Not supported by this Token");
    }

    public boolean isEqual() throws TokenException {
        if (this.username_.length() == 0) {
            throw new TokenException("no user given");
        }
        try {
            return this.userManager_.getUser(this.username_).authenticate(this.passwordFromUser_);
        }
        catch (EntityNotFoundException ex) {
            return false;
        }
    }

    public boolean contains() throws TokenException {
        throw new TokenException("Not supported by this Token");
    }

    public String toString() {
        return "Action: " + this.action_ + ", Result must be: " + this.result_ + ", with Key: " + this.key_;
    }

    public boolean makeAuthentication() throws TokenException {
        if (this.action_.equals("isEqual")) {
            boolean result;
            boolean bl = result = !(this.result_ ^ this.isEqual());
            if (!result) {
                this.errorMsg_ = ERROR_MESSAGE;
            }
            return result;
        }
        if (this.action_.equals("isLower")) {
            return !(this.result_ ^ this.isLower());
        }
        if (this.action_.equals("isGreater")) {
            return !(this.result_ ^ this.isGreater());
        }
        if (this.action_.equals("contains")) {
            return !(this.result_ ^ this.contains());
        }
        return false;
    }

    public String getErrorMessage() {
        return this.errorMsg_;
    }
}

