/*
 * Decompiled with CFR 0.152.
 */
package server.security;

import at.tugraz.genome.crypt.DesEncrypter;
import at.tugraz.genome.usermanagement.server.authentication.cache.CookieKeyCache;
import at.tugraz.genome.usermanagement.server.config.ConfigLoader;
import at.tugraz.genome.usermanagement.server.user.cache.ExtendedUserVOCache;
import com.opensymphony.module.access.provider.ejb.application.OsApplicationPasswords;
import com.opensymphony.module.access.provider.ejb.application.OsApplicationPasswordsHome;
import com.opensymphony.module.user.User;
import com.opensymphony.module.user.UserManager;
import com.opensymphony.module.user.provider.ejb.util.Base64;
import com.opensymphony.module.user.provider.ejb.util.PasswordDigester;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import server.Management.application.ApplicationManager;
import server.Management.application.ApplicationManagerHome;
import server.Management.rights.authentication.logging.LoginDataHandler;
import server.security.AuthenticationIDGenerator;

public class AuthenticationHandler
extends Thread {
    private static final Log logger_ = LogFactory.getLog((Class)(class$server$security$AuthenticationHandler == null ? (class$server$security$AuthenticationHandler = AuthenticationHandler.class$("server.security.AuthenticationHandler")) : class$server$security$AuthenticationHandler));
    private static AuthenticationHandler handler_ = null;
    private static AuthenticationIDGenerator generator_;
    private static HashMap idMap_;
    private static HashMap applicationMap_;
    private static HashMap userAllowedMap_;
    private static HashMap idToUserAllowedMap_;
    private static int checkTime;
    private static String DELETE_IDS_TIME;
    private static boolean started;
    public static final int IS_ALLOWD = 1;
    public static final int IS_NOT_ALLOWD = 0;
    public static final int IS_NOT_CACHED = -1;
    static /* synthetic */ Class class$server$security$AuthenticationHandler;
    static /* synthetic */ Class class$server$Management$application$ApplicationManagerHome;
    static /* synthetic */ Class class$com$opensymphony$module$access$provider$ejb$application$OsApplicationPasswordsHome;

    private AuthenticationHandler() {
        generator_ = AuthenticationIDGenerator.getInstance();
        idMap_ = new HashMap();
        applicationMap_ = new HashMap();
        userAllowedMap_ = new HashMap();
        idToUserAllowedMap_ = new HashMap();
        this.loadApplicationPasswords();
        DELETE_IDS_TIME = ConfigLoader.getInstance().getProperties().getProperty("id_delete_time");
        if (DELETE_IDS_TIME == null) {
            DELETE_IDS_TIME = "4";
        }
        logger_.info((Object)("will delete all ID at " + DELETE_IDS_TIME));
    }

    public static synchronized AuthenticationHandler getInstance() {
        if (handler_ == null) {
            handler_ = new AuthenticationHandler();
            logger_.info((Object)"Now I am starting my AuthenticationHandler thread!!!!!");
            handler_.start();
        }
        return handler_;
    }

    private synchronized void updateAllUsersInCache() {
        UserManager userManager_ = UserManager.getInstance();
        ExtendedUserVOCache.getInstance().emptyCache();
        List userList = userManager_.getUsers();
        Iterator iter = userList.iterator();
        LoginDataHandler loginHandler = LoginDataHandler.getInstance();
        loginHandler.emptyCache();
        boolean chechForExpiry = false;
        String checkForExpiredMail = ConfigLoader.getInstance().getProperties().getProperty("checkForExpiredMail");
        if (checkForExpiredMail != null && (checkForExpiredMail.equalsIgnoreCase("true") || checkForExpiredMail.equalsIgnoreCase("yes"))) {
            chechForExpiry = true;
        }
        logger_.debug((Object)"got all users");
        while (iter.hasNext()) {
            User user = (User)iter.next();
            logger_.info((Object)user.getName());
            if (user.getName().startsWith("prj_") || user.getName().endsWith("$")) continue;
            ExtendedUserVOCache cache = ExtendedUserVOCache.getInstance();
            cache.updateUser(user.getName());
            if (!chechForExpiry) continue;
            cache.checkForExpiryEmail(user.getName());
        }
    }

    private synchronized void updateCookieKeyCache() {
        CookieKeyCache.getInstance().refreshCache();
        logger_.debug((Object)"key cache refreshed");
    }

    public static String getID(String username) {
        if (idMap_.containsKey(username)) {
            return (String)idMap_.get(username);
        }
        Long id = new Long(generator_.getID());
        idMap_.put(username, id.toString());
        logger_.debug((Object)("AUTHENTICATION ID CREATED " + id));
        return id.toString();
    }

    public static synchronized String refreshAuthenticationId(String username, String authenticationID, Long cookieAgeInSeconds) {
        String returnString = "false";
        logger_.info((Object)"Refreshing the AuthenticationID!!!");
        logger_.info((Object)("Old id: " + authenticationID));
        if (idMap_.containsKey(username)) {
            System.out.println(authenticationID);
            System.out.println((String)idMap_.get(username));
            if (((String)idMap_.get(username)).equalsIgnoreCase(authenticationID)) {
                idMap_.remove(username);
                LoginDataHandler.getInstance().refreshExpectedLogoutTime(username, cookieAgeInSeconds);
                String authId = AuthenticationHandler.getID(username);
                logger_.info((Object)("New id: " + authId));
                return authId;
            }
        }
        return returnString;
    }

    public static synchronized void removeID(String username) {
        if (idMap_.containsKey(username)) {
            idMap_.remove(username);
        }
        if (idToUserAllowedMap_.containsKey(username)) {
            Vector realms = (Vector)idToUserAllowedMap_.get(username);
            int i = 0;
            while (i != realms.size()) {
                String realm = (String)realms.get(i);
                if (userAllowedMap_.containsKey(username + "_" + realm)) {
                    userAllowedMap_.remove(username + "_" + realm);
                }
                ++i;
            }
            idToUserAllowedMap_.remove(username);
        }
    }

    public static boolean isLogged(String username, String id) {
        String idInMap = (String)idMap_.get(username);
        if (idInMap == null) {
            return false;
        }
        return id.equals(idInMap);
    }

    private static String createHash(String original) {
        byte[] digested = PasswordDigester.digest(original.getBytes());
        byte[] encoded = Base64.encode(digested);
        return new String(encoded);
    }

    private static boolean compareHash(String hashedValue, String unhashedValue) {
        String hash = AuthenticationHandler.createHash(unhashedValue);
        return hashedValue.equals(hash);
    }

    public static int isApplicationRegistered(String application, String password, String version) {
        logger_.debug((Object)("isApplicationRegistered: application :" + application));
        int registeredStatus = 0;
        logger_.debug((Object)("Keyversion: " + version));
        String actualServerVersion = CookieKeyCache.getInstance().getVersion();
        logger_.debug((Object)("Actual Version: " + actualServerVersion));
        if (!actualServerVersion.equalsIgnoreCase(version)) {
            logger_.info((Object)"THE VERSION IS NOT THE SAME RETRIEVE YOUR KEY!!!!!!!!!!!!!!!!!");
            return 2;
        }
        DesEncrypter crypt = new DesEncrypter(CookieKeyCache.getInstance().getKey());
        String decryptedPassword = crypt.decrypt(password);
        String pwStored = (String)applicationMap_.get(application);
        if (pwStored == null) {
            return 0;
        }
        if (decryptedPassword.trim().equals(pwStored.trim())) {
            registeredStatus = 1;
        }
        return registeredStatus;
    }

    private static synchronized void loadApplicationPasswords() {
        applicationMap_.clear();
        Vector passwds = AuthenticationHandler.getApplicationPasswords();
        Iterator iter = passwds.iterator();
        while (iter.hasNext()) {
            OsApplicationPasswords passwd = (OsApplicationPasswords)iter.next();
            applicationMap_.put(passwd.getName(), passwd.getPassword());
            logger_.debug((Object)("add password of application " + passwd.getName()));
        }
    }

    public void updateApplicationPasswords() {
        this.loadApplicationPasswords();
        logger_.info((Object)"updated all applicationpasswords");
    }

    public static boolean isUserAdminOfApplication(String username, String applicationname) {
        logger_.debug((Object)("isUserAdminOfApplication " + username + " " + applicationname));
        ApplicationManager applicationManager_ = AuthenticationHandler.getApplicationManager();
        try {
            return applicationManager_.isAdminOfRealm(applicationname, username);
        }
        catch (RemoteException ex) {
            return false;
        }
    }

    public int isUserAllowdInApplication(String username, String realm) {
        if (userAllowedMap_.containsKey(username + "_" + realm)) {
            logger_.debug((Object)("isUserAllowdInApplication found in cache:" + username + " " + realm));
            StatusTime st = (StatusTime)userAllowedMap_.get(username + "_" + realm);
            if (st.getTime() + 300000L > System.currentTimeMillis()) {
                if (st.getStatus()) {
                    return 1;
                }
                return 0;
            }
            return -1;
        }
        return -1;
    }

    public void setInCacheIsUserAllowedInApplication(String username, String realm, boolean allowed) {
        logger_.info((Object)"setInCacheIsUserAllowedInApplication");
        StatusTime st = new StatusTime(allowed, System.currentTimeMillis());
        userAllowedMap_.put(username + "_" + realm, st);
        Vector realms = new Vector();
        if (idToUserAllowedMap_.containsKey(username)) {
            realms = (Vector)idToUserAllowedMap_.get(username);
            boolean containsRealm = false;
            int i = 0;
            while (i != realms.size()) {
                if (((String)realms.get(i)).equalsIgnoreCase(realm)) {
                    containsRealm = true;
                }
                ++i;
            }
            if (!containsRealm) {
                realms.add(realm);
            }
        } else {
            realms.add(realm);
        }
        idToUserAllowedMap_.put(username, realms);
    }

    private static ApplicationManager getApplicationManager() {
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("ApplicationManager");
            ApplicationManagerHome applicationManagerHome = (ApplicationManagerHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$server$Management$application$ApplicationManagerHome == null ? (class$server$Management$application$ApplicationManagerHome = AuthenticationHandler.class$("server.Management.application.ApplicationManagerHome")) : class$server$Management$application$ApplicationManagerHome));
            return applicationManagerHome.create();
        }
        catch (RemoteException ex) {
            logger_.error((Object)ex);
            return null;
        }
        catch (CreateException ex) {
            logger_.error((Object)ex);
            return null;
        }
        catch (ClassCastException ex) {
            logger_.error((Object)ex);
            return null;
        }
        catch (NamingException ex) {
            logger_.error((Object)ex);
            return null;
        }
    }

    private static Vector getApplicationPasswords() {
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("OsApplicationPasswords");
            OsApplicationPasswordsHome applicationManagerHome = (OsApplicationPasswordsHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$access$provider$ejb$application$OsApplicationPasswordsHome == null ? (class$com$opensymphony$module$access$provider$ejb$application$OsApplicationPasswordsHome = AuthenticationHandler.class$("com.opensymphony.module.access.provider.ejb.application.OsApplicationPasswordsHome")) : class$com$opensymphony$module$access$provider$ejb$application$OsApplicationPasswordsHome));
            return new Vector(applicationManagerHome.findAll());
        }
        catch (FinderException ex) {
            logger_.error((Object)ex);
            return null;
        }
        catch (ClassCastException ex) {
            logger_.error((Object)ex);
            return null;
        }
        catch (NamingException ex) {
            logger_.error((Object)ex);
            return null;
        }
    }

    public String getCookieKey(String realm) {
        String key = CookieKeyCache.getInstance().getKeyAndVersion();
        DesEncrypter crypt = new DesEncrypter((String)applicationMap_.get(realm));
        key = crypt.encrypt(key);
        return key;
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(checkTime);
                Date date = new Date();
                if (date.getHours() != new Long(DELETE_IDS_TIME).intValue()) continue;
                this.updateAllUsersInCache();
                this.updateCookieKeyCache();
                this.loadApplicationPasswords();
                continue;
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void triggerUserRefresh() {
        this.updateAllUsersInCache();
        this.updateCookieKeyCache();
        this.loadApplicationPasswords();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        checkTime = 2700000;
        started = false;
    }

    private class StatusTime {
        boolean status_;
        long time_;

        StatusTime(boolean status, long time) {
            this.status_ = status;
            this.time_ = time;
        }

        public long getTime() {
            return this.time_;
        }

        public boolean getStatus() {
            return this.status_;
        }
    }
}

