<%@ page language="java"
    import="at.tugraz.genome.usermanagement.UserManagementConstants,
    at.tugraz.genome.usermanagement.server.user.VO.*,
    at.tugraz.genome.web.WebConstants"
%>
<%@ taglib uri="/WEB-INF/struts-layout.tld" prefix="layout" %>
<%@ taglib uri="/WEB-INF/struts-html.tld" prefix="html" %>
<%@ taglib uri="/WEB-INF/login.tld" prefix="login" %>
<%@ taglib uri="/WEB-INF/checkPermission.tld" prefix="permission" %>
<%@ taglib uri="/WEB-INF/struts-bean.tld" prefix="bean" %>
<%@ taglib uri="/WEB-INF/struts-logic.tld" prefix="logic" %>

<html:html>
<head>
<title>Instituts</title>
<login:checkLogin applicationName='<%=WebConstants.MY_APPLICATION_NAME%>'/>
<link rel="stylesheet" type="text/css" href="<html:rewrite page='/css/Genome.css'/>">
<script type="text/javascript" src="<html:rewrite page='/js/Genome.js'/>"></script>
<html:base />
</head>
<body>
<fieldset><legend><b>Instituts</b></legend>
<html:errors/>
<html:form action="/showInstitut.do?action=show"  method="POST">
<table width="70%" class="StandardTable">
<tr>
    <td class="Table3DHead">Available fields</td>
  </tr>
  <tr>
 <td nowrap class="Table3DCellOdd">
      <table class="FormTable">
        <tr>
          <td nowrap valign="top">
            <b>&nbsp;Required information&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</b><br>
            <html:checkbox property="showName" tabindex="1"/> name <br>
            <html:checkbox property="showAddress" tabindex="2"/> address <br>
            <html:checkbox property="showCity" tabindex="3"/> city  <br>
            <html:checkbox property="showEmail" tabindex="4"/> email <br>
          </td>
          <td nowrap valign="top" width="220">
            <br>
            <html:checkbox property="showTelephone" tabindex="5"/> telephone  <br>
            <html:checkbox property="showFax" tabindex="6"/> faxnumber <br%>
            <html:checkbox property="showCountry" tabindex="7"/> country <br%>
          </td>
        </tr>
      </table>
</td>
</tr>
  </tr>
  <tr>
    <td colspan="4" class="Table3DCellOdd">
      <table border="0" cellspacing="0" class="FormTable">
        <tr>
          <td align="center">
           <html:submit value="Submit" property="update"/>
          </td>
        </tr>
      </table>
    </td>
  </tr>
</table>
<table class="FormTable" cellspacing="3">
<tr>
<td class="StandardTableCellOdd" colspan="2">
<layout:collection name="<%=WebConstants.INSTITUT_LIST%>" align="left" title="List of all institutes" styleClass="Table3DCellOdd" styleClass2="Table3DCellEven"  sortAction="client" id="infoItem">
    <layout:collectionItem title=""><html:img align="center" src="/UsermanagementWeb/images/dc.png"/></layout:collectionItem>
    <layout:collectionItem title="show members">
	<bean:define id="id" name="infoItem" property="id"/>
	<bean:define id="institutename" name="infoItem" property="name"/>
         <html:link href="/UsermanagementWeb/showInformationInstitut.do?action=show" paramName="infoItem" paramId="id" paramProperty="id" styleClass="SubMenuLink"  onmouseout="window.status='';" onmouseover="window.status='click to see institute members!.'; return true;"><bean:write name="institutename"/></html:link>
    </layout:collectionItem>
    <logic:present name='<%=WebConstants.SHOW_CITY%>'>
     <layout:collectionItem title="city" sortable="true" property="city"/>
    </logic:present>
    <logic:present name='<%=WebConstants.SHOW_ADDRESS%>'>
     <layout:collectionItem title="address" property="address"/>
    </logic:present>
    <logic:present name='<%=WebConstants.SHOW_COUNTRY%>'>
    <layout:collectionItem title="country" property="country"/>
    </logic:present>
    <logic:present name='<%=WebConstants.SHOW_INSTITUT_EMAIL%>'>
     <layout:collectionItem title="email" property="email"/>
    </logic:present>
    <logic:present name='<%=WebConstants.SHOW_FAX%>'>
     <layout:collectionItem title="fax" property="fax"/>
    </logic:present>
    <logic:present name='<%=WebConstants.SHOW_TELEPHONE%>'>
     <layout:collectionItem title="telephone" property="telephone"/>
    </logic:present>
    <permission:hasPermission resourceKey="institute" accessLevel="N">
       <layout:collectionItem title="Edit" width="80">
         <bean:define id="id" name="infoItem" property="id"/>
         <html:link href="/UsermanagementWeb/editInstitut.do?action=edit" paramName="infoItem" paramId="id" paramProperty="id" styleClass="SubMenuLink"  onmouseout="window.status='';" onmouseover="window.status='click to edit institute data!.'; return true;">edit</html:link>
       </layout:collectionItem>
    </permission:hasPermission>
    <permission:hasPermission resourceKey="institute" accessLevel="D">
       <layout:collectionItem title="Delete"  width="80">
         <bean:define id="id" name="infoItem" property="id"/>
         <html:link href="/UsermanagementWeb/showInstitut.do?action=delete" onclick="return confirm('Really delete the institut ?');" paramName="infoItem" paramId="id" paramProperty="id" styleClass="SubMenuLink"  onmouseout="window.status='';" onmouseover="window.status='click to delete institute!.'; return true;">delete</html:link>
       </layout:collectionItem>
    </permission:hasPermission>
</layout:collection>
</td>
</tr>
</table>
</html:form>
</fieldset>
</body>
</html:html>
