<%@ page language="java"
    import="at.tugraz.genome.web.WebConstants"
%>
<%@ taglib uri="/WEB-INF/struts-html.tld" prefix="html"%>
<%@ taglib uri="/WEB-INF/struts-layout.tld" prefix="layout" %>
<%@ taglib uri="/WEB-INF/login.tld" prefix="login" %>
<%@ taglib uri="/WEB-INF/checkPermission.tld" prefix="permission" %>
<%@ taglib uri="/WEB-INF/struts-logic.tld" prefix="logic" %>

<login:checkLogin applicationName='<%=WebConstants.MY_APPLICATION_NAME%>'/>
<html:html locale="true">
<head>
<title>create a new Resource for a Application</title>
<link rel="stylesheet" type="text/css" href="<html:rewrite page='/css/Genome.css'/>">
<script type="text/javascript" src="<html:rewrite page='/js/Genome.js'/>"></script>
<html:base/>
</head>
<fieldset><legend><b>create Resources</b></legend>
<html:errors/>
<html:form action="/createResources.do?action=submit" styleClass="StandardTable3D" method="POST">
<table width="70%" class="StandardTable">
  <tr>
     <td class="StandardTableCellEven"><html:img align="center" src="/UsermanagementWeb/images/app.png"/></td>
     <td class="StandardTableCellEven">Select Application: </td>
     <td class="StandardTableCellOdd">
     <html:select styleClass="ComboBox" property="realm" onchange="this.form.submit()">
        <html:options collection='<%=WebConstants.APPLICATION_LIST%>' property ="applicationname" labelProperty="applicationname"/>
     </html:select>
     </td>
  </tr>
  <logic:present name="<%=WebConstants.SUCCESS%>">
  <tr>
     <td class="StandardTableCellEven"><html:img align="center" src="/UsermanagementWeb/images/yes.png"/></td>
     <td class="StandardTableCellEven">Message : </td>
     <td class="StandardTableCellOdd">
     <html:text maxlength="200" readonly="true" size="45" property="message"/>
     </td>
  </tr>
  </logic:present>
  <tr>
     <td class="StandardTableCellEven"><html:img align="center" src="/UsermanagementWeb/images/resource.png"/></td>
     <td class="StandardTableCellEven">Key of Resource: </td>
     <td class="StandardTableCellOdd"><html:text maxlength="200" styleClass="TextFieldRequiredLarge" size="60" title="add new keyname for resource, key must be unique in application" property="key"/><td>
  </tr>
  <tr>
     <td class="StandardTableCellEven"><html:img align="center" src="/UsermanagementWeb/images/resource.png"/></td>
     <td class="StandardTableCellEven">existing keys: </td>
     <td class="StandardTableCellOdd"><html:textarea readonly="true" property="existingResources" rows="5" cols="40" title="describe the resource in a few words"/><td>
  </tr>
  <tr>
     <td class="StandardTableCellEven"><html:img align="center" src="/UsermanagementWeb/images/description.png"/></td>
     <td class="StandardTableCellEven">Description Resource: </td>
     <td class="StandardTableCellOdd">
     <html:textarea property="description" rows="5" cols="40" title="describe the resource in a few words"/></td>
  </tr>
  <tr>
     <td class="StandardTableCellEven"><html:img align="center" src="/UsermanagementWeb/images/pysol.png"/></td>
     <td class="StandardTableCellEven">Read Access: </td>
     <td class="StandardTableCellOdd">
     <html:checkbox altKey="read" title="read access" property="availableAccessRead"/></td>
  </tr>
  <tr>
     <td class="StandardTableCellEven"><html:img align="center" src="/UsermanagementWeb/images/pysol.png"/></td>
     <td class="StandardTableCellEven">Write Access: </td>
     <td class="StandardTableCellOdd">
     <html:checkbox altKey="write" title="write access" property="availableAccessWrite"/></td>
  </tr>
  <tr>
     <td class="StandardTableCellEven"><html:img align="center" src="/UsermanagementWeb/images/pysol.png"/></td>
     <td class="StandardTableCellEven">New Access: </td>
     <td class="StandardTableCellOdd">
     <html:checkbox altKey="new" title="new access" property="availableAccessNew"/></td>
  </tr>
  <tr>
     <td class="StandardTableCellEven"><html:img align="center" src="/UsermanagementWeb/images/pysol.png"/></td>
     <td class="StandardTableCellEven">Delete Access: </td>
     <td class="StandardTableCellOdd">
     <html:checkbox altKey="delete" title="delete access" property="availableAccessDelete"/></td>
  </tr>
  <tr>
     <td class="StandardTableCellEven"><html:img align="center" src="/UsermanagementWeb/images/pysol.png"/></td>
     <td class="StandardTableCellEven">Update Access: </td>
     <td class="StandardTableCellOdd">
     <html:checkbox altKey="update" title="add access" property="availableAccessUpdate"/></td>
  </tr>
  <permission:hasPermission resourceKey="resources" accessLevel="N">
  <tr>
  <td class="StandardTableCellOdd" align="center" colspan="3">
   <layout:submit property="create"/>
  </td>
  </tr>
  </permission:hasPermission>
</table>
</html:form>
</fieldset>
</html:html>
