-- MySQL dump 9.08
--
-- Host: localhost    Database: usermanagement
---------------------------------------------------------
-- Server version	4.0.14-standard-log

DROP DATABASE usermanagement;

CREATE DATABASE usermanagement;
GRANT ALL PRIVILEGES ON usermanagement.* TO usermn@localhost IDENTIFIED BY 'usermn';
USE usermanagement;

--
-- Table structure for table 'OS_ACL'
--

CREATE TABLE OS_ACL (
  ID bigint(20) NOT NULL default '0',
  REALM varchar(250) binary default NULL,
  RESOURCEKEY varchar(250) binary default NULL,
  ACCESSLEVEL varchar(250) binary default NULL,
  GROUPID varchar(250) binary default NULL,
  USERID varchar(250) binary default NULL,
  PRIMARY KEY  (ID)
) TYPE=MyISAM;

--
-- Dumping data for table 'OS_ACL'
--

INSERT INTO OS_ACL VALUES (1,'UserManagement','acls','R|W|N|',NULL,'admin');
INSERT INTO OS_ACL VALUES (2,'UserManagement','resources','R|W|N|D|',NULL,'admin');
INSERT INTO OS_ACL VALUES (3,'UserManagement','users','R|W|N|D|',NULL,'admin');
INSERT INTO OS_ACL VALUES (4,'UserManagement','groups','R|W|N|D|',NULL,'admin');
INSERT INTO OS_ACL VALUES (5,'UserManagement','application','R|W|N|D|',NULL,'admin');
INSERT INTO OS_ACL VALUES (6,'UserManagement','mailManager','R|W|N|D|',NULL,'admin');
INSERT INTO OS_ACL VALUES (7,'UserManagement','remote','R|W|N|D|',NULL,'admin');
INSERT INTO OS_ACL VALUES (8,'UserManagement','unixServer','R|U|N|D|',NULL,'admin');
INSERT INTO OS_ACL VALUES (9,'UserManagement','institute','R|N|W|D|',NULL,'admin');
INSERT INTO OS_ACL VALUES (10,'UserManagement','project','R|U|N|D|',NULL,'admin');
INSERT INTO OS_ACL VALUES (11,'UserManagement','computer','R|U|N|D|',NULL,'admin');
INSERT INTO OS_ACL VALUES (12,'UserManagement','users','R|W|N|D|','usermanagement_admins',NULL);
INSERT INTO OS_ACL VALUES (13,'UserManagement','groups','R|W|N|D|','usermanagement_admins',NULL);
INSERT INTO OS_ACL VALUES (14,'UserManagement','acls','R|W|N|D|','usermanagement_admins',NULL);
INSERT INTO OS_ACL VALUES (17,'tma','datadictionary','D|R|N|U|','tmaAdmin',NULL);
INSERT INTO OS_ACL VALUES (18,'tma','algorithm','R|W|N|D|','tmaAdmin',NULL);
INSERT INTO OS_ACL VALUES (19,'tma','arraytype','R|W|N|D|','tmaAdmin',NULL);
INSERT INTO OS_ACL VALUES (20,'tma','antigen','R|U|N|D|','tmaAdmin',NULL);
INSERT INTO OS_ACL VALUES (21,'tma','result','R|U|N|D|','tmaAdmin',NULL);
INSERT INTO OS_ACL VALUES (30,'tma','persons','R|U|N|D|','tmaAdmin',NULL);
INSERT INTO OS_ACL VALUES (31,'tma','fileUpload','R|U|N|D|','tmaAdmin',NULL);
INSERT INTO OS_ACL VALUES (32,'tma','tissues','R|U|N|D|','tmaAdmin',NULL);
INSERT INTO OS_ACL VALUES (33,'tma','donor','R|U|N|D|','tmaAdmin',NULL);
INSERT INTO OS_ACL VALUES (34,'tma','arrayblock','D|R|N|U|','tmaAdmin',NULL);
INSERT INTO OS_ACL VALUES (35,'tma','section','R|U|N|D|','tmaAdmin',NULL);
INSERT INTO OS_ACL VALUES (36,'tma','staining','R|U|N|D|','tmaAdmin',NULL);
INSERT INTO OS_ACL VALUES (37,'tma','antibody','D|R|N|U|','tmaAdmin',NULL);
INSERT INTO OS_ACL VALUES (43,'tma','persons','R|U|N|','tmaUser',NULL);
INSERT INTO OS_ACL VALUES (44,'tma','fileUpload','R|U|N|','tmaUser',NULL);
INSERT INTO OS_ACL VALUES (45,'tma','tissues','R|U|N|','tmaUser',NULL);
INSERT INTO OS_ACL VALUES (46,'tma','donor','R|U|N|','tmaUser',NULL);
INSERT INTO OS_ACL VALUES (47,'tma','arrayblock','R|U|N|','tmaUser',NULL);
INSERT INTO OS_ACL VALUES (48,'tma','section','R|U|N|','tmaUser',NULL);
INSERT INTO OS_ACL VALUES (49,'tma','staining','R|U|N|','tmaUser',NULL);
INSERT INTO OS_ACL VALUES (50,'tma','antibody','R|N|U|','tmaUser',NULL);
INSERT INTO OS_ACL VALUES (51,'tma','datadictionary','R|','tmaUser',NULL);
INSERT INTO OS_ACL VALUES (52,'tma','algorithm','R|W|N|','tmaUser',NULL);
INSERT INTO OS_ACL VALUES (53,'tma','arraytype','R|W|N|','tmaUser',NULL);
INSERT INTO OS_ACL VALUES (54,'tma','antigen','R|U|N|','tmaUser',NULL);
INSERT INTO OS_ACL VALUES (55,'tma','result','R|W|N|','tmaUser',NULL);
INSERT INTO OS_ACL VALUES (56,'tma','persons','R|','tmaGuest',NULL);
INSERT INTO OS_ACL VALUES (57,'tma','fileUpload','R|','tmaGuest',NULL);
INSERT INTO OS_ACL VALUES (58,'tma','tissues','R|','tmaGuest',NULL);
INSERT INTO OS_ACL VALUES (59,'tma','donor','R|','tmaGuest',NULL);
INSERT INTO OS_ACL VALUES (60,'tma','arrayblock','R|','tmaGuest',NULL);
INSERT INTO OS_ACL VALUES (61,'tma','section','R|','tmaGuest',NULL);
INSERT INTO OS_ACL VALUES (62,'tma','staining','R|','tmaGuest',NULL);
INSERT INTO OS_ACL VALUES (63,'tma','antibody','R|','tmaGuest',NULL);
INSERT INTO OS_ACL VALUES (64,'tma','datadictionary','R|','tmaGuest',NULL);
INSERT INTO OS_ACL VALUES (65,'tma','algorithm','R|','tmaGuest',NULL);
INSERT INTO OS_ACL VALUES (66,'tma','arraytype','R|','tmaGuest',NULL);
INSERT INTO OS_ACL VALUES (67,'tma','antigen','R|','tmaGuest',NULL);
INSERT INTO OS_ACL VALUES (68,'tma','result','R|','tmaGuest',NULL);

--
-- Table structure for table 'OS_ADMINS'
--

CREATE TABLE OS_ADMINS (
  ID bigint(20) NOT NULL default '0',
  REALM varchar(250) binary default NULL,
  USERNAME varchar(250) binary default NULL,
  PRIMARY KEY  (ID)
) TYPE=MyISAM;

--
-- Dumping data for table 'OS_ADMINS'
--

INSERT INTO OS_ADMINS VALUES (1,'UserManagement','admin');

--
-- Table structure for table 'OS_ADMINSGROUP'
--

CREATE TABLE OS_ADMINSGROUP (
  ID bigint(20) NOT NULL default '0',
  REALM varchar(250) binary default NULL,
  GROUPNAME varchar(250) binary default NULL,
  PRIMARY KEY  (ID)
) TYPE=MyISAM;

--
-- Dumping data for table 'OS_ADMINSGROUP'
--


--
-- Table structure for table 'OS_APPLICATIONS'
--

CREATE TABLE OS_APPLICATIONS (
  REALM varchar(250) binary NOT NULL default '',
  OSRESOURCEPROVIDER varchar(250) binary default NULL,
  OSUSERPROVIDER varchar(250) binary default NULL,
  RESOURCELOCATION varchar(250) binary default NULL,
  ACLLOCATION varchar(250) binary default NULL,
  PRIMARY KEY  (REALM)
) TYPE=MyISAM;

--
-- Dumping data for table 'OS_APPLICATIONS'
--

INSERT INTO OS_APPLICATIONS VALUES ('UserManagement','com.opensymphony.module.access.provider.ejb.EJBResourceProvider','com.opensymphony.module.access.provider.osuser.OSUserUserProvider','Resource','Acl');
INSERT INTO OS_APPLICATIONS VALUES ('tma','com.opensymphony.module.access.provider.ejb.EJBResourceProvider','com.opensymphony.module.access.provider.osuser.OSUserUserProvider','Resource','Acl');

--
-- Table structure for table 'OS_APPLICATION_PASSWORDS'
--

CREATE TABLE OS_APPLICATION_PASSWORDS (
  ID bigint(20) NOT NULL default '0',
  NAME varchar(250) binary default NULL,
  PASSWORD varchar(250) binary default NULL,
  PRIMARY KEY  (ID)
) TYPE=MyISAM;

--
-- Dumping data for table 'OS_APPLICATION_PASSWORDS'
--

INSERT INTO OS_APPLICATION_PASSWORDS VALUES (1,'UserManagement','YrK2p8l4PqMtlrkFyPLCGxsbVh33c46FsgaF614dy5DBbWGvBqxM9UZukiT7nvxHWsHnQM8YVClDv9zayo1kACX');
INSERT INTO OS_APPLICATION_PASSWORDS VALUES (3,'tma','CspGXdBiFthtcNMfHwScNCHRJLrbFGqHfVMZYHNSItgyjIkCzlAfLTWfuBzv');

--
-- Table structure for table 'OS_AUTHENTICATIONRULES'
--

CREATE TABLE OS_AUTHENTICATIONRULES (
  REALM varchar(250) binary NOT NULL default '',
  RULEFILE longblob,
  PRIMARY KEY  (REALM)
) TYPE=MyISAM;

--
-- Dumping data for table 'OS_AUTHENTICATIONRULES'
--

INSERT INTO OS_AUTHENTICATIONRULES VALUES ('UserManagement','<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<Authentication>\n<PasswordToken id=\"checkPassword\">\n      <isEqual result=\"true\">password</isEqual>\n </PasswordToken>\n      <DateToken id=\"checkEnabled\">      <isLower result=\"true\">startdate</isLower>\n      </DateToken>\n      <DateToken id=\"checkExpired\">      <isGreater result=\"true\">expiredate</isGreater>\n      </DateToken>\n </Authentication>\n');
INSERT INTO OS_AUTHENTICATIONRULES VALUES ('tma','<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<Authentication>\n<PasswordToken id=\"checkPassword\">\n      <isEqual result=\"true\">password</isEqual>\n </PasswordToken>\n      <DateToken id=\"checkEnabled\">      <isLower result=\"true\">startdate</isLower>\n      </DateToken>\n      <DateToken id=\"checkExpired\">      <isGreater result=\"true\">expiredate</isGreater>\n      </DateToken>\n </Authentication>\n');


--
-- Table structure for table 'OS_DEFAULTGROUP'
--

CREATE TABLE OS_DEFAULTGROUP (
  REALM varchar(250) binary NOT NULL default '',
  GROUPNAME varchar(250) binary default NULL,
  PRIMARY KEY  (REALM)
) TYPE=MyISAM;

--
-- Dumping data for table 'OS_DEFAULTGROUP'
--


--
-- Table structure for table 'OS_DEFAULTUSER'
--

CREATE TABLE OS_DEFAULTUSER (
  REALM varchar(250) binary NOT NULL default '',
  USERNAME varchar(250) binary default NULL,
  PRIMARY KEY  (REALM)
) TYPE=MyISAM;

--
-- Dumping data for table 'OS_DEFAULTUSER'
--


--
-- Table structure for table 'OS_GROUP'
--

CREATE TABLE OS_GROUP (
  ID bigint(20) NOT NULL default '0',
  GROUPNAME varchar(250) binary default NULL,
  PRIMARY KEY  (ID)
) TYPE=MyISAM;

--
-- Dumping data for table 'OS_GROUP'
--

INSERT INTO OS_GROUP VALUES (1,'usermanagement_admins');
INSERT INTO OS_GROUP VALUES (2,'tmaAdmin');
INSERT INTO OS_GROUP VALUES (3,'tmaUser');
INSERT INTO OS_GROUP VALUES (4,'tmaGuest');

--
-- Table structure for table 'OS_GROUPINREALM'
--

CREATE TABLE OS_GROUPINREALM (
  ID bigint(20) NOT NULL default '0',
  GROUPNAME varchar(250) binary default NULL,
  REALM varchar(250) binary default NULL,
  ISENABLED bigint(20) default NULL,
  PRIMARY KEY  (ID)
) TYPE=MyISAM;

--
-- Dumping data for table 'OS_GROUPINREALM'
--

INSERT INTO OS_GROUPINREALM VALUES (1,'usermanagement_admins','UserManagement',1);
INSERT INTO OS_GROUPINREALM VALUES (2,'tmaAdmin','tma',1);
INSERT INTO OS_GROUPINREALM VALUES (3,'tmaGuest','tma',1);
INSERT INTO OS_GROUPINREALM VALUES (4,'tmaUser','tma',1);

--
-- Table structure for table 'OS_INSTITUTES'
--

CREATE TABLE OS_INSTITUTES (
  ID bigint(20) NOT NULL default '0',
  NAME varchar(250) binary default NULL,
  ADDRESS varchar(250) binary default NULL,
  CITY varchar(250) binary default NULL,
  TELEPHONE varchar(250) binary default NULL,
  EMAIL varchar(250) binary default NULL,
  FAX varchar(250) binary default NULL,
  COUNTRY varchar(250) binary default NULL,
  PRIMARY KEY  (ID)
) TYPE=MyISAM;

--
-- Dumping data for table 'OS_INSTITUTES'
--
INSERT INTO OS_INSTITUTES VALUES (1,'Institute for Genomics and Bioinformatics','Petersgasse 14','8010 Graz','+43-316-873-5332','Zlatko.Trajanoski@tugraz.at','+43-316-873-5340','Austria');


--
-- Table structure for table 'OS_INSTIUTE_MEMBERS'
--

CREATE TABLE OS_INSTIUTE_MEMBERS (
  ID bigint(20) NOT NULL default '0',
  INSTITUTID bigint(20) default NULL,
  USERNAME varchar(250) binary default NULL,
  MAININSTITUTE tinyint(4) default NULL,
  PRIMARY KEY  (ID)
) TYPE=MyISAM;

--
-- Dumping data for table 'OS_INSTIUTE_MEMBERS'
--

INSERT INTO OS_INSTIUTE_MEMBERS VALUES (1,1,'admin',1);
INSERT INTO OS_INSTIUTE_MEMBERS VALUES (2,1,'test',1);

--
-- Table structure for table 'OS_LASTLOGIN'
--

CREATE TABLE OS_LASTLOGIN (
  ID bigint(20) NOT NULL default '0',
  USERNAME varchar(250) binary default NULL,
  APPLICATION varchar(250) binary default NULL,
  LASTLOGIN bigint(20) default NULL,
  PRIMARY KEY  (ID)
) TYPE=MyISAM;

--
-- Dumping data for table 'OS_LASTLOGIN'
--

INSERT INTO OS_LASTLOGIN VALUES (1,'admin','UserManagement',1138866425304);

--
-- Table structure for table 'OS_LOGGING'
--

CREATE TABLE OS_LOGGING (
  ID bigint(20) NOT NULL default '0',
  USERNAME varchar(250) binary default NULL,
  REALM varchar(250) binary default NULL,
  LOGINDATE bigint(20) default NULL,
  SUCCESS bigint(20) default NULL,
  MESSAGE varchar(250) binary default NULL,
  EXPECTED_LOGOUTDATE bigint(20) default NULL,
  LOGOUTDATE bigint(20) default NULL,
  LOGOUT_REALM varchar(250) binary default NULL,
  PRIMARY KEY  (ID)
) TYPE=MyISAM;

--
-- Dumping data for table 'OS_LOGGING'
--

INSERT INTO OS_LOGGING VALUES (1,'admin','UserManagement',1169311307442,2,'admin logged in successfully  from IP 127.0.0.1',1169314907442,1169311735017,'UserManagement');

--
-- Table structure for table 'OS_LOGIN_FAILURES'
--

CREATE TABLE OS_LOGIN_FAILURES (
  id bigint(20) NOT NULL default '0',
  username varchar(250) binary default NULL,
  loginfailures bigint(20) default NULL,
  ipaddress varchar(250) binary default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table 'OS_LOGIN_FAILURES'
--


--
-- Table structure for table 'OS_MEMBERSHIP'
--

CREATE TABLE OS_MEMBERSHIP (
  ID bigint(20) NOT NULL default '0',
  GROUPNAME varchar(250) binary default NULL,
  USERNAME varchar(250) binary default NULL,
  PRIMARY KEY  (ID)
) TYPE=MyISAM;

--
-- Dumping data for table 'OS_MEMBERSHIP'
--

INSERT INTO OS_MEMBERSHIP VALUES (1,'tmaAdmin','test');

--
-- Table structure for table 'OS_PASSWORD_OLD_FOUR'
--

CREATE TABLE OS_PASSWORD_OLD_FOUR (
  id bigint(20) NOT NULL default '0',
  username varchar(250) binary default NULL,
  one varchar(250) binary default NULL,
  two varchar(250) binary default NULL,
  three varchar(250) binary default NULL,
  four varchar(250) binary default NULL,
  currentpwd bigint(20) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table 'OS_PASSWORD_OLD_FOUR'
--

INSERT INTO OS_PASSWORD_OLD_FOUR VALUES (1,'admin','0',NULL,NULL,NULL,NULL);

--
-- Table structure for table 'OS_PASSWORD_PERIODIC'
--

CREATE TABLE OS_PASSWORD_PERIODIC (
  id bigint(20) NOT NULL default '0',
  username varchar(250) binary default NULL,
  period bigint(20) default NULL,
  pwdtype varchar(250) binary default NULL,
  pwdate bigint(20) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table 'OS_PASSWORD_PERIODIC'
--

INSERT INTO OS_PASSWORD_PERIODIC VALUES (1,'admin',0,'never',1105522200530);
INSERT INTO OS_PASSWORD_PERIODIC VALUES (2,'test',0,'never',1169241046707);

--
-- Table structure for table 'OS_PROPERTYDATA'
--

CREATE TABLE OS_PROPERTYDATA (
  ID bigint(20) NOT NULL default '0',
  VALUE longblob,
  PRIMARY KEY  (ID)
) TYPE=MyISAM;

--
-- Dumping data for table 'OS_PROPERTYDATA'
--


--
-- Table structure for table 'OS_PROPERTYDATE'
--

CREATE TABLE OS_PROPERTYDATE (
  ID bigint(20) NOT NULL default '0',
  VALUE bigint(20) default NULL,
  PRIMARY KEY  (ID)
) TYPE=MyISAM;

--
-- Dumping data for table 'OS_PROPERTYDATE'
--

INSERT INTO OS_PROPERTYDATE VALUES (1,1262770199873);
INSERT INTO OS_PROPERTYDATE VALUES (2,1104830999873);
INSERT INTO OS_PROPERTYDATE VALUES (41,1293829845936);
INSERT INTO OS_PROPERTYDATE VALUES (42,1136149845936);

--
-- Table structure for table 'OS_PROPERTYDECIMAL'
--

CREATE TABLE OS_PROPERTYDECIMAL (
  ID bigint(20) NOT NULL default '0',
  VALUE double default NULL,
  PRIMARY KEY  (ID)
) TYPE=MyISAM;

--
-- Dumping data for table 'OS_PROPERTYDECIMAL'
--


--
-- Table structure for table 'OS_PROPERTYENTRY'
--

CREATE TABLE OS_PROPERTYENTRY (
  ID bigint(20) NOT NULL default '0',
  PROPTYPE int(11) NOT NULL default '0',
  KEYNAME varchar(250) binary default NULL,
  ENTITYNAME varchar(250) binary default NULL,
  ENTITYID bigint(20) default NULL,
  PRIMARY KEY  (ID)
) TYPE=MyISAM;

--
-- Dumping data for table 'OS_PROPERTYENTRY'
--

INSERT INTO OS_PROPERTYENTRY VALUES (1,7,'expiredate','os.PropertyEntry',1);
INSERT INTO OS_PROPERTYENTRY VALUES (2,7,'startdate','os.PropertyEntry',1);
INSERT INTO OS_PROPERTYENTRY VALUES (3,5,'email','os.PropertyEntry',1);
INSERT INTO OS_PROPERTYENTRY VALUES (4,5,'fullName','os.PropertyEntry',1);
INSERT INTO OS_PROPERTYENTRY VALUES (38,5,'fullName','os.PropertyEntry',2);
INSERT INTO OS_PROPERTYENTRY VALUES (39,5,'fullName','os.PropertyEntry',3);
INSERT INTO OS_PROPERTYENTRY VALUES (40,5,'email','os.PropertyEntry',3);
INSERT INTO OS_PROPERTYENTRY VALUES (41,7,'expiredate','os.PropertyEntry',3);
INSERT INTO OS_PROPERTYENTRY VALUES (42,7,'startdate','os.PropertyEntry',3);

--
-- Table structure for table 'OS_PROPERTYNUMBER'
--

CREATE TABLE OS_PROPERTYNUMBER (
  ID bigint(20) NOT NULL default '0',
  VALUE bigint(20) default NULL,
  PRIMARY KEY  (ID)
) TYPE=MyISAM;

--
-- Dumping data for table 'OS_PROPERTYNUMBER'
--


--
-- Table structure for table 'OS_PROPERTYSTRING'
--

CREATE TABLE OS_PROPERTYSTRING (
  ID bigint(20) NOT NULL default '0',
  VALUE varchar(250) binary default NULL,
  PRIMARY KEY  (ID)
) TYPE=MyISAM;

--
-- Dumping data for table 'OS_PROPERTYSTRING'
--

INSERT INTO OS_PROPERTYSTRING VALUES (3,'AAS@genome.tugraz.at');
INSERT INTO OS_PROPERTYSTRING VALUES (4,'AAS Administrator');
INSERT INTO `os_propertystring` VALUES (39,'Otto Tester');
INSERT INTO `os_propertystring` VALUES (40,'TAMEE@genome.tugraz.at');

--
-- Table structure for table 'OS_RESOURCE'
--

CREATE TABLE OS_RESOURCE (
  ID bigint(20) NOT NULL default '0',
  REALM varchar(250) binary default NULL,
  RESOURCEKEY varchar(250) binary default NULL,
  DESCRIPTION varchar(250) binary default NULL,
  AVAILACCESS varchar(250) binary default NULL,
  PRIMARY KEY  (ID)
) TYPE=MyISAM;

--
-- Dumping data for table 'OS_RESOURCE'
--

INSERT INTO OS_RESOURCE VALUES (1,'UserManagement','resources','Resources','R|W|N|D|');
INSERT INTO OS_RESOURCE VALUES (2,'UserManagement','acls','Access Control Lists','R|W|N|D|');
INSERT INTO OS_RESOURCE VALUES (3,'UserManagement','users','Users add/delete etc.','R|W|N|D|');
INSERT INTO OS_RESOURCE VALUES (4,'UserManagement','groups','Groups add/delete etc.','R|W|N|D|');
INSERT INTO OS_RESOURCE VALUES (5,'UserManagement','remote','Remote User add/delete etc.','R|W|N|D|');
INSERT INTO OS_RESOURCE VALUES (6,'UserManagement','application','Applications add/delete etc.','R|W|N|D|');
INSERT INTO OS_RESOURCE VALUES (7,'UserManagement','mailManager','send Mails','R|W|N|');
INSERT INTO OS_RESOURCE VALUES (8,'UserManagement','institute','manage the institutes','R|W|U|N|D|');
INSERT INTO OS_RESOURCE VALUES (9,'UserManagement','project','not available','R|U|N|D|');
INSERT INTO OS_RESOURCE VALUES (10,'UserManagement','computer','not available','R|U|N|D|');
INSERT INTO OS_RESOURCE VALUES (11,'UserManagement','unixServer','not available','R|U|N|D|');
INSERT INTO OS_RESOURCE VALUES (12,'tma','datadictionary','not available','R|W|U|N|D|');
INSERT INTO OS_RESOURCE VALUES (13,'tma','algorithm','not available','R|W|U|N|D|');
INSERT INTO OS_RESOURCE VALUES (14,'tma','arraytype','not available','R|W|U|N|D|');
INSERT INTO OS_RESOURCE VALUES (15,'tma','antigen','not available','R|W|U|N|D|');
INSERT INTO OS_RESOURCE VALUES (16,'tma','result','not available','R|W|U|N|D|');
INSERT INTO OS_RESOURCE VALUES (22,'tma','persons','not available','R|U|N|D|');
INSERT INTO OS_RESOURCE VALUES (23,'tma','fileUpload','not available','R|U|N|D|');
INSERT INTO OS_RESOURCE VALUES (24,'tma','tissues','not available','R|U|N|D|');
INSERT INTO OS_RESOURCE VALUES (25,'tma','donor','not available','R|U|N|D|');
INSERT INTO OS_RESOURCE VALUES (26,'tma','arrayblock','not available','R|W|U|N|D|');
INSERT INTO OS_RESOURCE VALUES (27,'tma','section','not available','R|W|U|N|D|');
INSERT INTO OS_RESOURCE VALUES (28,'tma','staining','not available','R|W|U|N|D|');
INSERT INTO OS_RESOURCE VALUES (29,'tma','antibody','not available','R|W|U|N|D|');

--
-- Table structure for table 'OS_SEQUENCE'
--

CREATE TABLE OS_SEQUENCE (
  NAME varchar(250) binary NOT NULL default '',
  ACTUALCOUNT bigint(20) NOT NULL default '0',
  PRIMARY KEY  (NAME)
) TYPE=MyISAM;

--
-- Dumping data for table 'OS_SEQUENCE'
--

INSERT INTO OS_SEQUENCE VALUES ('os.Adminsgroup',0);
INSERT INTO OS_SEQUENCE VALUES ('os.Group',4);
INSERT INTO OS_SEQUENCE VALUES ('os.GroupInRealm',4);
INSERT INTO OS_SEQUENCE VALUES ('os.GroupsLdap',0);
INSERT INTO OS_SEQUENCE VALUES ('os.InstitutMember',4);
INSERT INTO OS_SEQUENCE VALUES ('os.LdapEntry',0);
INSERT INTO OS_SEQUENCE VALUES ('os.Logging',1);
INSERT INTO OS_SEQUENCE VALUES ('os.LoginFailures',0);
INSERT INTO OS_SEQUENCE VALUES ('os.Membership',1);
INSERT INTO OS_SEQUENCE VALUES ('os.PropertyEntry',68);
INSERT INTO OS_SEQUENCE VALUES ('os.User',3);
INSERT INTO OS_SEQUENCE VALUES ('os.UserInRealm',1);
INSERT INTO OS_SEQUENCE VALUES ('os.UnixServer',0);
INSERT INTO OS_SEQUENCE VALUES ('os.organizationalunitsLdap',0);
INSERT INTO OS_SEQUENCE VALUES ('sambaProject',0);
INSERT INTO OS_SEQUENCE VALUES ('sambaProjectPermission',0);
INSERT INTO OS_SEQUENCE VALUES ('OsInstitutes',1);
INSERT INTO OS_SEQUENCE VALUES ('OsPasswordPeriode',2);
INSERT INTO OS_SEQUENCE VALUES ('OsPasswordOldFourBean',1);
INSERT INTO OS_SEQUENCE VALUES ('OsLastloginBean',1);
INSERT INTO OS_SEQUENCE VALUES ('GroupmembersLdap',0);

--
-- Table structure for table 'OS_TEMPLATEUSERS'
--

CREATE TABLE OS_TEMPLATEUSERS (
  ID bigint(20) NOT NULL default '0',
  REALM varchar(250) binary default NULL,
  USERNAME varchar(250) binary default NULL,
  PRIMARY KEY  (ID)
) TYPE=MyISAM;

--
-- Dumping data for table 'OS_TEMPLATEUSERS'
--


--
-- Table structure for table 'OS_USER'
--

CREATE TABLE OS_USER (
  id bigint(20) NOT NULL default '0',
  username varchar(250) binary default NULL,
  PASSWORDHASH varchar(250) binary default NULL,
  uidnumber bigint(20) default NULL,
  gidnumber bigint(20) default NULL,
  loginShell varchar(250) binary default NULL,
  homeDirectory varchar(250) binary default NULL,
  shadowMin bigint(20) default NULL,
  shadowMax bigint(20) default NULL,
  shadowWarning bigint(20) default NULL,
  shadowInactive bigint(20) default NULL,
  shadowExpire bigint(20) default NULL,
  shadowFlag bigint(20) default NULL,
  domain varchar(250) binary default NULL,
  dir_drive varchar(250) binary default NULL,
  logon_script varchar(250) binary default NULL,
  workstations varchar(250) binary default NULL,
  user_sid varchar(250) binary default NULL,
  lm_pw varchar(250) binary default NULL,
  nt_pw varchar(250) binary default NULL,
  profile_path varchar(250) binary default NULL,
  logon_time bigint(20) default NULL,
  logoff_time bigint(20) default NULL,
  kickoff_time bigint(20) default NULL,
  pass_last_set_time bigint(20) default NULL,
  pass_can_change_time bigint(20) default NULL,
  pass_must_change_time bigint(20) default NULL,
  acct_desc varchar(250) binary default NULL,
  samba_dir varchar(250) binary default NULL,
  description varchar(250) binary default NULL,
  samba_group_id bigint(20) default NULL,
  applicationAuthEnabled bigint(20) default NULL,
  ldapAuthenticationEnabled bigint(20) default NULL,
  shadowLastChange bigint(20) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table 'OS_USER'
--

INSERT INTO OS_USER VALUES (1,'admin','{CRYPT}$1$iSUfxNH$c1yRW3etJo5IyWQbddxuz.',2,-1,NULL,'not available',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'not available','','AEBD4DE384C7EC43AAD3B435B51404EE','7A21990FCD3D759941E45C490F143D5F','not available',NULL,NULL,NULL,1105522200,1105522200,2147483,NULL,'not available','',NULL,1,0,NULL);
INSERT INTO OS_USER VALUES (3,'test','{CRYPT}$1$oZOCGVN$5OGM00t498ymv9xBXIuOf0',-1,-1,NULL,'',0,0,0,0,0,0,NULL,NULL,NULL,'false',NULL,'AEBD4DE384C7EC43AAD3B435B51404EE','7A21990FCD3D759941E45C490F143D5F',NULL,NULL,NULL,NULL,1169240891,1169240891,2147483647,NULL,NULL,NULL,NULL,1,0,NULL);

--
-- Table structure for table 'OS_USERINREALM'
--

CREATE TABLE OS_USERINREALM (
  ID bigint(20) NOT NULL default '0',
  USERNAME varchar(250) binary default NULL,
  REALM varchar(250) binary default NULL,
  ISENABLED bigint(20) default NULL,
  PRIMARY KEY  (ID)
) TYPE=MyISAM;

--
-- Dumping data for table 'OS_USERINREALM'
--

INSERT INTO OS_USERINREALM VALUES (1,'admin','UserManagement',1);

--
-- Table structure for table 'OS_USER_CHANGEPASSWORD'
--

CREATE TABLE OS_USER_CHANGEPASSWORD (
  USERNAME varchar(250) binary NOT NULL default '',
  PRIMARY KEY  (USERNAME)
) TYPE=MyISAM;

--
-- Dumping data for table 'OS_USER_CHANGEPASSWORD'
--


--
-- Table structure for table 'groupmembers_ldap'
--

CREATE TABLE groupmembers_ldap (
  id bigint(20) NOT NULL default '0',
  memberUid varchar(250) binary default NULL,
  group_id bigint(20) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table 'groupmembers_ldap'
--


--
-- Table structure for table 'groups_ldap'
--

CREATE TABLE groups_ldap (
  id bigint(20) NOT NULL default '0',
  dn varchar(250) binary default NULL,
  description varchar(250) binary default NULL,
  gidNumber bigint(20) default NULL,
  cn varchar(250) binary default NULL,
  displayName varchar(250) binary default NULL,
  sambaSID varchar(250) binary default NULL,
  sambaGroupType bigint(20) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table 'groups_ldap'
--


--
-- Table structure for table 'ldap_entries'
--

CREATE TABLE ldap_entries (
  ID bigint(20) NOT NULL default '0',
  DN varchar(250) binary default NULL,
  OC_MAP_ID bigint(20) default NULL,
  PARENT bigint(20) default NULL,
  KEYVAL bigint(20) default NULL,
  PRIMARY KEY  (ID)
) TYPE=MyISAM;

--
-- Dumping data for table 'ldap_entries'
--


--
-- Table structure for table 'ldap_entry_objclasses'
--

CREATE TABLE ldap_entry_objclasses (
  entry_id bigint(20) NOT NULL default '0',
  oc_name varchar(250) binary NOT NULL default '',
  PRIMARY KEY  (entry_id,oc_name)
) TYPE=MyISAM;

--
-- Dumping data for table 'ldap_entry_objclasses'
--


--
-- Table structure for table 'ldap_oc_mappings'
--

CREATE TABLE ldap_oc_mappings (
  id int(11) NOT NULL default '0',
  name varchar(250) binary default NULL,
  keytbl varchar(250) binary default NULL,
  keycol varchar(250) binary default NULL,
  create_proc varchar(250) binary default NULL,
  delete_proc varchar(250) binary default NULL,
  expect_return tinyint(4) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table 'ldap_oc_mappings'
--


--
-- Table structure for table 'organizationalunits_ldap'
--

CREATE TABLE organizationalunits_ldap (
  id bigint(20) NOT NULL default '0',
  dn varchar(250) binary default NULL,
  ou varchar(250) binary default NULL,
  description varchar(250) binary default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table 'organizationalunits_ldap'
--


--
-- Table structure for table 'organizations_ldap'
--

CREATE TABLE organizations_ldap (
  id bigint(20) NOT NULL default '0',
  dn varchar(250) binary default NULL,
  o varchar(250) binary default NULL,
  dc varchar(250) binary default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table 'organizations_ldap'
--


--
-- Table structure for table 'samba_domain_ldap'
--

CREATE TABLE samba_domain_ldap (
  id double NOT NULL default '0',
  sambaDomainName varchar(250) binary default NULL,
  sambaSID varchar(250) binary default NULL,
  sambaAlgorithmicRidBase varchar(250) binary default NULL,
  sambaNextUserRid double default NULL,
  sambaNextGroupRid double default NULL,
  sambaPDCHostname varchar(250) binary default NULL,
  sambaHomeDir varchar(250) binary default NULL,
  windowsHomeDir varchar(250) binary default NULL,
  profilePath varchar(250) binary default NULL,
  dirDrive varchar(250) binary default NULL,
  loginShell varchar(250) binary default NULL,
  sambaDefaultLogonScript varchar(250) binary default NULL,
  sambaProjectPath varchar(250) binary default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table 'samba_domain_ldap'
--


--
-- Table structure for table 'samba_group'
--

CREATE TABLE samba_group (
  id bigint(20) NOT NULL default '0',
  displayName varchar(250) binary default NULL,
  Name varchar(250) binary default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table 'samba_group'
--


--
-- Table structure for table 'samba_project'
--

CREATE TABLE samba_project (
  id bigint(20) NOT NULL default '0',
  name varchar(250) binary default NULL,
  description varchar(250) binary default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table 'samba_project'
--


--
-- Table structure for table 'samba_project_permission'
--

CREATE TABLE samba_project_permission (
  id bigint(20) NOT NULL default '0',
  purpose varchar(250) binary default NULL,
  groups_ldap_id bigint(20) default NULL,
  samba_project_id bigint(20) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table 'samba_project_permission'
--


--
-- Table structure for table 'samba_project_sambaGroup'
--

CREATE TABLE samba_project_sambaGroup (
  samba_projectId bigint(20) NOT NULL default '0',
  samba_groupId bigint(20) NOT NULL default '0',
  PRIMARY KEY  (samba_projectId,samba_groupId)
) TYPE=MyISAM;

--
-- Dumping data for table 'samba_project_sambaGroup'
--


--
-- Table structure for table 'samba_project_user'
--

CREATE TABLE samba_project_user (
  samba_projectId bigint(20) NOT NULL default '0',
  userid bigint(20) NOT NULL default '0',
  PRIMARY KEY  (samba_projectId,userid)
) TYPE=MyISAM;

--
-- Dumping data for table 'samba_project_user'
--

--
-- Table structure for table `shared_group`
--

CREATE TABLE `shared_group` (
  `REALM` varchar(250) binary NOT NULL default '',
  `GROUPNAME` varchar(250) binary NOT NULL default '',
  PRIMARY KEY  (`REALM`,`GROUPNAME`)
);

--
-- Dumping data for table `shared_group`
--


--
-- Table structure for table `sub_institute`
--

CREATE TABLE `sub_institute` (
  `MAIN_INSTITUTE_ID` bigint(20) NOT NULL default '0',
  `SUB_INSTITUTE_ID` bigint(20) NOT NULL default '0',
  PRIMARY KEY  (`MAIN_INSTITUTE_ID`,`SUB_INSTITUTE_ID`)
);

--
-- Dumping data for table `sub_institute`
--

--
-- Table structure for table 'unix_server'
--

CREATE TABLE unix_server (
  id bigint(20) NOT NULL default '0',
  servername varchar(250) binary default NULL,
  ip varchar(250) binary default NULL,
  PasswordDES varchar(250) binary default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

--
-- Dumping data for table 'unix_server'
--
