-- MySQL dump 9.08
--
-- Host: localhost    Database: tma
---------------------------------------------------------
-- Server version	4.0.14-standard-log

DROP DATABASE tma;

CREATE DATABASE tma;
GRANT ALL PRIVILEGES ON tma.* TO tmadbuser@localhost IDENTIFIED BY 'tmadbuser';
SET MAX_ALLOWED_PACKET = 100000000;
SET FOREIGN_KEY_CHECKS = 0;
USE tma;


--
-- Table structure for table 'JMS_MESSAGES'
--

CREATE TABLE JMS_MESSAGES (
  MESSAGEID int(11) NOT NULL default '0',
  DESTINATION varchar(150) NOT NULL default '',
  TXID int(11) default NULL,
  TXOP char(1) default NULL,
  MESSAGEBLOB longblob,
  PRIMARY KEY  (MESSAGEID,DESTINATION),
  KEY JMS_MESSAGES_TXOP_TXID (TXOP,TXID),
  KEY JMS_MESSAGES_DESTINATION (DESTINATION)
) TYPE=MyISAM;

--
-- Dumping data for table 'JMS_MESSAGES'
--


--
-- Table structure for table 'JMS_TRANSACTIONS'
--

CREATE TABLE JMS_TRANSACTIONS (
  TXID int(11) NOT NULL default '0',
  PRIMARY KEY  (TXID)
) TYPE=MyISAM;

--
-- Dumping data for table 'JMS_TRANSACTIONS'
--


--
-- Table structure for table 'TMASERVERPROPERTIES'
--

CREATE TABLE TMASERVERPROPERTIES (
  PROPERTY varchar(150) default NULL,
  VALUE varchar(255) default NULL
) TYPE=MyISAM;

--
-- Dumping data for table 'TMASERVERPROPERTIES'
--

INSERT INTO TMASERVERPROPERTIES VALUES ('DATABASE','mySQL');
INSERT INTO TMASERVERPROPERTIES VALUES ('DATAROOTDIRECTORY','D:\\Development\\Data\\');
INSERT INTO TMASERVERPROPERTIES VALUES ('GUESTUSERALLOWED','FALSE');

--
-- Table structure for table 'algorithms'
--

CREATE TABLE algorithms (
  AlgorithmID bigint(20) NOT NULL default '0',
  Algoname varchar(255) default NULL,
  Jarname varchar(255) default NULL,
  Version varchar(255) default NULL,
  Startable int(2) default NULL,
  Disabled int(2) default NULL,
  PRIMARY KEY  (AlgorithmID),
  KEY iAlgorithmID (AlgorithmID)
) TYPE=InnoDB;

--
-- Dumping data for table 'algorithms'
--

INSERT INTO algorithms VALUES (100,'QCAlgorithm', 'QCAlgorithm.jar', '1.3', 1, 0);
INSERT INTO algorithms VALUES (101,'RGcalibration', 'RGcalibration.jar', '1.2', 0, 0);

--
-- Table structure for table 'algorithmseq'
--

CREATE TABLE algorithmseq (
  ID bigint(20) default NULL
) TYPE=MyISAM;

--
-- Dumping data for table 'algorithmseq'
--

INSERT INTO algorithmseq VALUES (102);

--
-- Table structure for table 'algorithmspersection'
--

CREATE TABLE algorithmspersection (
  ApersectionID bigint(20) NOT NULL default '0',
  AlgorithmID bigint(20) default NULL,
  SectionID bigint(20) default NULL,
  PRIMARY KEY  (ApersectionID),
  KEY SectionID (SectionID),
  KEY iAlgorithmID (AlgorithmID),
  CONSTRAINT `0_278` FOREIGN KEY (`AlgorithmID`) REFERENCES `algorithms` (`AlgorithmID`),
  CONSTRAINT `0_174` FOREIGN KEY (`SectionID`) REFERENCES `section` (`SectionID`)
) TYPE=InnoDB;

--
-- Dumping data for table 'algorithmspersection'
--

--
-- Table structure for table 'antibody'
--

CREATE TABLE antibody (
  AntibodyID bigint(20) NOT NULL default '0',
  Antibodyname varchar(255) default NULL,
  Clonenumber varchar(255) default NULL,
  IgtypeID bigint(20) default NULL,
  SpeciesID bigint(20) default NULL,
  CompanyID bigint(20) default NULL,
  TypeID bigint(20) default NULL,
  PRIMARY KEY  (AntibodyID),
  KEY aSpeciesID (SpeciesID),
  KEY CompanyID (CompanyID),
  KEY IgtypeID (IgtypeID),
  KEY TypeID (TypeID),
  CONSTRAINT `0_176` FOREIGN KEY (`SpeciesID`) REFERENCES `datadictionary` (`DataID`),
  CONSTRAINT `0_177` FOREIGN KEY (`CompanyID`) REFERENCES `datadictionary` (`DataID`),
  CONSTRAINT `0_178` FOREIGN KEY (`IgtypeID`) REFERENCES `datadictionary` (`DataID`),
  CONSTRAINT `0_179` FOREIGN KEY (`TypeID`) REFERENCES `datadictionary` (`DataID`)
) TYPE=InnoDB;

--
-- Dumping data for table 'antibody'
--

--
-- Table structure for table 'antibodyseq'
--

CREATE TABLE antibodyseq (
  ID bigint(20) default NULL
) TYPE=MyISAM;

--
-- Dumping data for table 'antibodyseq'
--

INSERT INTO antibodyseq VALUES (100);

--
-- Table structure for table 'antigen'
--

CREATE TABLE antigen (
  AntigenID bigint(20) NOT NULL default '0',
  Antigenname varchar(255) default NULL,
  Genname varchar(255) default NULL,
  Accession varchar(255) default NULL,
  DatabaseID bigint(20) default NULL,
  PRIMARY KEY  (AntigenID),
  KEY DatabaseID (DatabaseID),
  CONSTRAINT `0_257` FOREIGN KEY (`DatabaseID`) REFERENCES `datadictionary` (`DataID`)
) TYPE=InnoDB;

--
-- Dumping data for table 'antigen'
--

--
-- Table structure for table 'antigenantibodyassociation'
--

CREATE TABLE antigenantibodyassociation (
  THE_ANTIBODY_FK bigint(20) NOT NULL default '0',
  THE_ANTIGEN_FK bigint(20) NOT NULL default '0',
  PRIMARY KEY  (THE_ANTIBODY_FK,THE_ANTIGEN_FK),
  KEY THE_ANTIGEN_FK (THE_ANTIGEN_FK),
  KEY THE_ANTIBODY_FK (THE_ANTIBODY_FK),
  CONSTRAINT `0_182` FOREIGN KEY (`THE_ANTIBODY_FK`) REFERENCES `antibody` (`AntibodyID`),
  CONSTRAINT `0_183` FOREIGN KEY (`THE_ANTIGEN_FK`) REFERENCES `antigen` (`AntigenID`)
) TYPE=InnoDB;

--
-- Dumping data for table 'antigenantibodyassociation'
--

--
-- Table structure for table 'antigenseq'
--

CREATE TABLE antigenseq (
  ID bigint(20) default NULL
) TYPE=MyISAM;

--
-- Dumping data for table 'antigenseq'
--

INSERT INTO antigenseq VALUES (100);

--
-- Table structure for table 'arrayblock'
--

CREATE TABLE arrayblock (
  ArrayblockID bigint(20) NOT NULL default '0',
  BarcodeID bigint(20) default NULL,
  EnteredBy bigint(20) default NULL,
  Date date default NULL,
  Csvfilename varchar(255) default NULL,
  Csv longblob,
  Name varchar(255) default NULL,
  ArraytypeID bigint(20) default NULL,
  CustomerID bigint(20) default NULL,
  PRIMARY KEY  (ArrayblockID),
  KEY ArraytypeID (ArraytypeID),
  KEY CustomerID (CustomerID),
  CONSTRAINT `0_185` FOREIGN KEY (`ArraytypeID`) REFERENCES `arraytype` (`ArraytypeID`),
  CONSTRAINT `0_186` FOREIGN KEY (`CustomerID`) REFERENCES `datadictionary` (`DataID`)
) TYPE=InnoDB;

--
-- Dumping data for table 'arrayblock'
--

--
-- Table structure for table 'arrayblockseq'
--

CREATE TABLE arrayblockseq (
  ID bigint(20) default NULL
) TYPE=MyISAM;

--
-- Dumping data for table 'arrayblockseq'
--

INSERT INTO arrayblockseq VALUES (100);

--
-- Table structure for table 'arraypunchassociation'
--

CREATE TABLE arraypunchassociation (
  ApassociationID bigint(20) NOT NULL default '0',
  Row int(11) default NULL,
  Col int(11) default NULL,
  ArrayblockID bigint(20) default NULL,
  DonorID bigint(20) default NULL,
  CoreIndex int(11) default NULL,
  CoreX int(11) default NULL,
  CoreY int(11) default NULL,
  PRIMARY KEY  (ApassociationID),
  KEY iApassociationID (ApassociationID),
  KEY iArrayblockID (ArrayblockID),
  KEY iDonorID (DonorID),
  CONSTRAINT `0_188` FOREIGN KEY (`DonorID`) REFERENCES `donor` (`DonorID`),
  CONSTRAINT `0_189` FOREIGN KEY (`ArrayblockID`) REFERENCES `arrayblock` (`ArrayblockID`)
) TYPE=InnoDB;

--
-- Dumping data for table 'arraypunchassociation'
--

--
-- Table structure for table 'arraypunchassociationseq'
--

CREATE TABLE arraypunchassociationseq (
  ID bigint(20) default NULL
) TYPE=MyISAM;

--
-- Dumping data for table 'arraypunchassociationseq'
--

INSERT INTO arraypunchassociationseq VALUES (100);

--
-- Table structure for table 'arraytype'
--

CREATE TABLE arraytype (
  ArraytypeID bigint(20) NOT NULL default '0',
  Arrayname varchar(255) default NULL,
  Rows int(11) default NULL,
  Cols int(11) default NULL,
  RowOffset double(8,4) default NULL,
  ColOffset double(8,4) default NULL,
  CoreDiameter double(8,4) default NULL,
  PRIMARY KEY  (ArraytypeID),
  KEY ArraytypeID (ArraytypeID)
) TYPE=InnoDB;

--
-- Dumping data for table 'arraytype'
--

--
-- Table structure for table 'arraytypeseq'
--

CREATE TABLE arraytypeseq (
  ID bigint(20) default NULL
) TYPE=MyISAM;

--
-- Dumping data for table 'arraytypeseq'
--

INSERT INTO arraytypeseq VALUES (100);

--
-- Table structure for table 'behaviour'
--

CREATE TABLE behaviour (
  BehaviourID bigint(20) NOT NULL default '0',
  Behaviour varchar(255) default NULL,
  PRIMARY KEY  (BehaviourID),
  KEY BehaviourID (BehaviourID)
) TYPE=InnoDB;

--
-- Dumping data for table 'behaviour'
--

INSERT INTO behaviour VALUES (0,'');
INSERT INTO behaviour VALUES (1,'Benign neoplasm');
INSERT INTO behaviour VALUES (2,'neoplasm of unknown behaviour');
INSERT INTO behaviour VALUES (3,'in situ neoplasm');
INSERT INTO behaviour VALUES (4,'malignant neoplasm');
INSERT INTO behaviour VALUES (5,'malignant, secondary');

--
-- Table structure for table 'datadictionary'
--

CREATE TABLE datadictionary (
  DataID bigint(20) NOT NULL default '0',
  Disable int(11) default NULL,
  Datatype varchar(255) default NULL,
  Datavalue varchar(255) default NULL,
  Datadescription varchar(255) default NULL,
  PRIMARY KEY  (DataID),
  KEY DataID (DataID)
) TYPE=InnoDB;

--
-- Dumping data for table 'datadictionary'
--

INSERT INTO datadictionary VALUES (00,0,'undefined',NULL,NULL);
INSERT INTO datadictionary VALUES (01,0,'DOMAIN','ANTIBODYTYPE',NULL);
INSERT INTO datadictionary VALUES (02,0,'DOMAIN','COLOR',NULL);
INSERT INTO datadictionary VALUES (03,0,'DOMAIN','COMPANY',NULL);
INSERT INTO datadictionary VALUES (04,0,'DOMAIN','CUSTOMER',NULL);
INSERT INTO datadictionary VALUES (05,0,'DOMAIN','CUTTER',NULL);
INSERT INTO datadictionary VALUES (06,0,'DOMAIN','DATABASE','');
INSERT INTO datadictionary VALUES (07,0,'DOMAIN','DYEINGMETHOD',NULL);
INSERT INTO datadictionary VALUES (08,0,'DOMAIN','IGTYPE',NULL);
INSERT INTO datadictionary VALUES (09,0,'DOMAIN','MICROTOME',NULL);
INSERT INTO datadictionary VALUES (10,0,'DOMAIN','PARAFFIN',NULL);
INSERT INTO datadictionary VALUES (11,0,'DOMAIN','PERSON',NULL);
INSERT INTO datadictionary VALUES (12,0,'DOMAIN','SITE',NULL);
INSERT INTO datadictionary VALUES (13,0,'DOMAIN','SLIDE',NULL);
INSERT INTO datadictionary VALUES (14,0,'DOMAIN','SOURCEDB',NULL);
INSERT INTO datadictionary VALUES (15,0,'DOMAIN','SPECIES',NULL);
INSERT INTO datadictionary VALUES (16,0,'DOMAIN','STAGINGT','');
INSERT INTO datadictionary VALUES (17,0,'DOMAIN','STAGINGN','');
INSERT INTO datadictionary VALUES (18,0,'DOMAIN','STAGINGM','');
INSERT INTO datadictionary VALUES (19,0,'DOMAIN','STAGINGR','');
INSERT INTO datadictionary VALUES (20,0,'DOMAIN','STORAGE','');
INSERT INTO datadictionary VALUES (21,0,'ANTIBODYTYPE','monoclonal','');
INSERT INTO datadictionary VALUES (22,0,'ANTIBODYTYPE','polyclonal','');
INSERT INTO datadictionary VALUES (23,0,'COLOR','Cy3','');
INSERT INTO datadictionary VALUES (24,0,'COLOR','Cy5','');
INSERT INTO datadictionary VALUES (25,0,'COLOR','HE','');
INSERT INTO datadictionary VALUES (26,1,'COMPANY','Bender MedSystems','');
INSERT INTO datadictionary VALUES (27,0,'COMPANY','Novo Castra','');
INSERT INTO datadictionary VALUES (28,0,'COMPANY','Progen','');
INSERT INTO datadictionary VALUES (29,0,'COMPANY','BD Biosciences','');
INSERT INTO datadictionary VALUES (30,0,'COMPANY','Becton Dickinson','');
INSERT INTO datadictionary VALUES (31,0,'CUSTOMER','Institute of Pathology','');
INSERT INTO datadictionary VALUES (32,0,'CUTTER','Cutter 1','');
INSERT INTO datadictionary VALUES (33,0,'CUTTER','Cutter 2','');
INSERT INTO datadictionary VALUES (34,0,'DATABASE','GenBank','');
INSERT INTO datadictionary VALUES (35,0,'DATABASE','RefSeq','');
INSERT INTO datadictionary VALUES (36,0,'DATABASE','Entrez Gene','');
INSERT INTO datadictionary VALUES (37,0,'DATABASE','Ensembl','');
INSERT INTO datadictionary VALUES (38,0,'DYEINGMETHOD','FISH',NULL);
INSERT INTO datadictionary VALUES (39,0,'DYEINGMETHOD','HE',NULL);
INSERT INTO datadictionary VALUES (40,0,'DYEINGMETHOD','IF',NULL);
INSERT INTO datadictionary VALUES (41,0,'DYEINGMETHOD','IHC',NULL);
INSERT INTO datadictionary VALUES (42,0,'DYEINGMETHOD','unstained',NULL);
INSERT INTO datadictionary VALUES (43,0,'IGTYPE','IgG1','');
INSERT INTO datadictionary VALUES (44,0,'IGTYPE','IgG2a','');
INSERT INTO datadictionary VALUES (45,0,'IGTYPE','Ig','');
INSERT INTO datadictionary VALUES (46,0,'IGTYPE','IgM','');
INSERT INTO datadictionary VALUES (47,0,'MICROTOME','SLEE rotary microtome 4060','');
INSERT INTO datadictionary VALUES (48,0,'MICROTOME','Microm HM355S','');
INSERT INTO datadictionary VALUES (49,0,'MICROTOME','Thermo Shandon Finesse','');
INSERT INTO datadictionary VALUES (50,0,'PARAFFIN','Precision Cut (Thermo Shandon, Runcorn, UK)','');
INSERT INTO datadictionary VALUES (51,0,'PARAFFIN','Sakura Tissue Tek III','');
INSERT INTO datadictionary VALUES (52,0,'PERSON','Person 1','');
INSERT INTO datadictionary VALUES (53,0,'PERSON','Person 2','');
INSERT INTO datadictionary VALUES (54,0,'SITE','site 1','');
INSERT INTO datadictionary VALUES (55,0,'SITE','site 2','');
INSERT INTO datadictionary VALUES (56,0,'SLIDE','Polysine (Menzel,  Braunschweig, Germany)','');
INSERT INTO datadictionary VALUES (57,0,'SLIDE','ChemMate capillary Gap Microscope Slides (Dako Cytomation)','');
INSERT INTO datadictionary VALUES (58,0,'SOURCE','source 1','');
INSERT INTO datadictionary VALUES (59,0,'SOURCE','source 2','');
INSERT INTO datadictionary VALUES (60,0,'SPECIES','homo sapiens','');
INSERT INTO datadictionary VALUES (61,0,'SPECIES','mus musculus','');
INSERT INTO datadictionary VALUES (62,0,'SPECIES','rattus norvegicus','');
INSERT INTO datadictionary VALUES (63,0,'SPECIES','oryctolagus cuniculus','');
INSERT INTO datadictionary VALUES (64,0,'SPECIES','capra hircus','');
INSERT INTO datadictionary VALUES (65,0,'STAGINGT','pTis','');
INSERT INTO datadictionary VALUES (66,0,'STAGINGT','pT1','');
INSERT INTO datadictionary VALUES (67,0,'STAGINGT','pT2','');
INSERT INTO datadictionary VALUES (68,0,'STAGINGT','pT3','');
INSERT INTO datadictionary VALUES (69,0,'STAGINGT','pT4','');
INSERT INTO datadictionary VALUES (70,0,'STAGINGT','pTX','');
INSERT INTO datadictionary VALUES (71,0,'STAGINGN','pN0','');
INSERT INTO datadictionary VALUES (72,0,'STAGINGN','pN1','');
INSERT INTO datadictionary VALUES (73,0,'STAGINGN','pN2','');
INSERT INTO datadictionary VALUES (74,0,'STAGINGN','pN3','');
INSERT INTO datadictionary VALUES (75,0,'STAGINGN','pNX','');
INSERT INTO datadictionary VALUES (76,0,'STAGINGM','pM0','');
INSERT INTO datadictionary VALUES (77,0,'STAGINGM','pM1','');
INSERT INTO datadictionary VALUES (78,0,'STAGINGM','pMX','');
INSERT INTO datadictionary VALUES (79,0,'STAGINGR','pR0','');
INSERT INTO datadictionary VALUES (80,0,'STAGINGR','pR1','');
INSERT INTO datadictionary VALUES (81,0,'STAGINGR','pR2','');
INSERT INTO datadictionary VALUES (82,0,'STAGINGR','pRX','');
INSERT INTO datadictionary VALUES (83,0,'STORAGE','Room temperature and air','');
INSERT INTO datadictionary VALUES (84,0,'STORAGE','Room temperature, and nitrogen','');
INSERT INTO datadictionary VALUES (85,0,'STORAGE','Room temperature, paraffin coated, and nitrogen','');

--
-- Table structure for table 'donor'
--

CREATE TABLE donor (
  DonorID bigint(20) NOT NULL default '0',
  Date date default NULL,
  EnteredBy bigint(20) default NULL,
  BarcodeID bigint(20) default NULL,
  Corecomment varchar(255) default NULL,
  TissueID bigint(20) default NULL,
  PersonID bigint(20) default NULL,
  PRIMARY KEY  (DonorID),
  KEY DonorID (DonorID),
  KEY TissueID (TissueID),
  KEY PersonID (PersonID),
  CONSTRAINT `0_194` FOREIGN KEY (`PersonID`) REFERENCES `datadictionary` (`DataID`),
  CONSTRAINT `0_195` FOREIGN KEY (`TissueID`) REFERENCES `tissues` (`TissueID`)
) TYPE=InnoDB;

--
-- Dumping data for table 'donor'
--


--
-- Table structure for table 'donorarrayassociation'
--

CREATE TABLE donorarrayassociation (
  THE_DONOR_FK bigint(20) NOT NULL default '0',
  THE_ARRAYBLOCK_FK bigint(20) NOT NULL default '0',
  PRIMARY KEY  (THE_DONOR_FK,THE_ARRAYBLOCK_FK),
  KEY THE_ARRAYBLOCK_FK (THE_ARRAYBLOCK_FK),
  KEY THE_DONOR_FK (THE_DONOR_FK),
  CONSTRAINT `0_197` FOREIGN KEY (`THE_DONOR_FK`) REFERENCES `donor` (`DonorID`),
  CONSTRAINT `0_198` FOREIGN KEY (`THE_ARRAYBLOCK_FK`) REFERENCES `arrayblock` (`ArrayblockID`)
) TYPE=InnoDB;

--
-- Dumping data for table 'donorarrayassociation'
--


--
-- Table structure for table 'donorimages'
--

CREATE TABLE donorimages (
  DonorimageID bigint(20) NOT NULL default '0',
  Image longblob,
  Imagename varchar(255) default NULL,
  Type int(11) default NULL,
  Description varchar(255) default NULL,
  DonorID bigint(20) default NULL,
  CapturedByID bigint(20) default NULL,
  SmallimageID bigint(20) default NULL,
  PRIMARY KEY  (DonorimageID),
  KEY DonorimageID (DonorimageID),
  KEY DonorID (DonorID),
  KEY SmallimageID (SmallimageID),
  KEY CapturedByID (CapturedByID),
  CONSTRAINT `0_200` FOREIGN KEY (`DonorID`) REFERENCES `donor` (`DonorID`),
  CONSTRAINT `0_201` FOREIGN KEY (`SmallimageID`) REFERENCES `smallimages` (`SmallimageID`),
  CONSTRAINT `0_202` FOREIGN KEY (`CapturedByID`) REFERENCES `datadictionary` (`DataID`)
) TYPE=InnoDB;

--
-- Dumping data for table 'donorimages'
--

--
-- Table structure for table 'donorimageseq'
--

CREATE TABLE donorimageseq (
  ID bigint(20) default NULL
) TYPE=MyISAM;

--
-- Dumping data for table 'donorimageseq'
--

INSERT INTO donorimageseq VALUES (100);

--
-- Table structure for table 'donorseq'
--

CREATE TABLE donorseq (
  ID bigint(20) default NULL
) TYPE=MyISAM;

--
-- Dumping data for table 'donorseq'
--

INSERT INTO donorseq VALUES (100);

--
-- Table structure for table 'emptyarraypositions'
--

CREATE TABLE emptyarraypositions (
  PositionsID bigint(20) NOT NULL default '0',
  Row int(11) default NULL,
  Col int(11) default NULL,
  ArraytypeID bigint(20) default NULL,
  PRIMARY KEY  (PositionsID),
  KEY ArraytypeID (ArraytypeID),
  CONSTRAINT `0_204` FOREIGN KEY (`ArraytypeID`) REFERENCES `arraytype` (`ArraytypeID`)
) TYPE=InnoDB;

--
-- Dumping data for table 'emptyarraypositions'
--

--
-- Table structure for table 'grade'
--

CREATE TABLE grade (
  GradeID bigint(20) NOT NULL default '0',
  Grade varchar(255) default NULL,
  PRIMARY KEY  (GradeID),
  KEY GradeID (GradeID)
) TYPE=InnoDB;

--
-- Dumping data for table 'grade'
--

INSERT INTO grade VALUES (0,'');
INSERT INTO grade VALUES (1,'G-1 : well differentiated');
INSERT INTO grade VALUES (2,'G-2 : moderately differentiated');
INSERT INTO grade VALUES (3,'G-3 : poorly differentiated');
INSERT INTO grade VALUES (4,'G-4 : undifferentiated/ anaplastic');
INSERT INTO grade VALUES (5,'G-x : grade not determined/ applicable');


--
-- Table structure for table 'morphology'
--

CREATE TABLE morphology (
  MorphologyID bigint(20) NOT NULL default '0',
  Morphology varchar(255) default NULL,
  PRIMARY KEY  (MorphologyID),
  KEY MorphologyID (MorphologyID)
) TYPE=InnoDB;

--
-- Dumping data for table 'morphology'
--

INSERT INTO morphology VALUES (0,'');
INSERT INTO morphology VALUES (8041,'SMALL CELL CARCINOMA');
INSERT INTO morphology VALUES (8050,'PAPILLARY CARCINOMA');
INSERT INTO morphology VALUES (8070,'SQUAMOUS CELL CARCINOMA');
INSERT INTO morphology VALUES (8090,'BASAL CELL CARCINOMA');
INSERT INTO morphology VALUES (8120,'TRANSITIONAL CELL CARCINOMA');
INSERT INTO morphology VALUES (8140,'ADENOCARCINOMA');
INSERT INTO morphology VALUES (8145,'ADENOCARCINOMA, NOS');
INSERT INTO morphology VALUES (8170,'LIVER CELL ADENOMA');
INSERT INTO morphology VALUES (8171,'FIBROLAMELLAR');
INSERT INTO morphology VALUES (8211,'TUBULAR CARCINOMA');
INSERT INTO morphology VALUES (8230,'DUCTALCARCINOMA');
INSERT INTO morphology VALUES (8240,'CARCINOID TUMOR');
INSERT INTO morphology VALUES (8246,'CARCINOID TUMOR, MALIGNANT');
INSERT INTO morphology VALUES (8252,'BRONCHOALVEOLAR CARCINOMA');
INSERT INTO morphology VALUES (8276,'NEUROENDOCRINE CARCINOMA');
INSERT INTO morphology VALUES (8310,'CLEAR CELL ADENOCARCINOMA');
INSERT INTO morphology VALUES (8312,'RENAL CELL CARCINOMA');
INSERT INTO morphology VALUES (8317,'CLEAR CELL ADENOCARCINOMA, NOS');
INSERT INTO morphology VALUES (8330,'FOLLICULAR ADENOMA');
INSERT INTO morphology VALUES (8345,'MEDULLARY CARCINOMA');
INSERT INTO morphology VALUES (8370,'ADERNAL CORTICAL CARCINOMA');
INSERT INTO morphology VALUES (8380,'ENDOMETRIOD CARCINOMA');
INSERT INTO morphology VALUES (8384,'ADENOCARCINOMA');
INSERT INTO morphology VALUES (8430,'MUCOEPIDERMOID CARCINOMA');
INSERT INTO morphology VALUES (8440,'CYSTADENOMA');
INSERT INTO morphology VALUES (8441,'CYSTADENOCARCINOMA, NOS');
INSERT INTO morphology VALUES (8480,'MUCINOUS ADENOCARCINOMA');
INSERT INTO morphology VALUES (8481,'COLLOID CARCINOMA');
INSERT INTO morphology VALUES (8490,'SIGNET RING CELL CARCINOMA');
INSERT INTO morphology VALUES (8500,'INTRADUCTAL CARCINOMA');
INSERT INTO morphology VALUES (8510,'MEDULLARY CARCINOMA');
INSERT INTO morphology VALUES (8520,'INFILTRATING LOBULAR CARCINOMA');
INSERT INTO morphology VALUES (8522,'LOBULAR AND OTHER DUCTAL CA.');
INSERT INTO morphology VALUES (8575,'METAPLASTIC CARCINOMA');
INSERT INTO morphology VALUES (8720,'MALIGNANT MELANOMA');
INSERT INTO morphology VALUES (9010,'FIBROADENOM');

--
-- Table structure for table 'punch'
--

CREATE TABLE punch (
  PunchID bigint(20) NOT NULL default '0',
  ApassociationID bigint(20) default NULL,
  SectionID bigint(20) default NULL,
  PRIMARY KEY  (PunchID),
  KEY ApassociationID (ApassociationID),
  KEY SectionID (SectionID),
  KEY PunchID (PunchID),
  CONSTRAINT `0_280` FOREIGN KEY (`SectionID`) REFERENCES `section` (`SectionID`),
  CONSTRAINT `0_210` FOREIGN KEY (`ApassociationID`) REFERENCES `arraypunchassociation` (`ApassociationID`)
) TYPE=InnoDB;

--
-- Dumping data for table 'punch'
--

--
-- Table structure for table 'punchimageresultassociation'
--

CREATE TABLE punchimageresultassociation (
  THE_RESULT_FK bigint(20) NOT NULL default '0',
  THE_PUNCHIMAGE_FK bigint(20) NOT NULL default '0',
  PRIMARY KEY  (THE_RESULT_FK,THE_PUNCHIMAGE_FK),
  KEY iTHE_PUNCHIMAGE_FK (THE_PUNCHIMAGE_FK),
  KEY iTHE_RESULT_FK (THE_RESULT_FK),
  CONSTRAINT `0_212` FOREIGN KEY (`THE_RESULT_FK`) REFERENCES `results` (`ResultID`),
  CONSTRAINT `0_213` FOREIGN KEY (`THE_PUNCHIMAGE_FK`) REFERENCES `punchimages` (`PunchimageID`)
) TYPE=InnoDB;

--
-- Dumping data for table 'punchimageresultassociation'
--


--
-- Table structure for table 'punchimages'
--

CREATE TABLE punchimages (
  PunchimageID bigint(20) NOT NULL default '0',
  Image longblob,
  Imagename varchar(255) default NULL,
  SectionimageID bigint(20) default NULL,
  PunchID bigint(20) default NULL,
  PRIMARY KEY  (PunchimageID),
  KEY PunchimageID (PunchimageID),
  KEY SectionimageID (SectionimageID),
  KEY PunchID (PunchID),
  CONSTRAINT `0_215` FOREIGN KEY (`PunchID`) REFERENCES `punch` (`PunchID`),
  CONSTRAINT `0_216` FOREIGN KEY (`SectionimageID`) REFERENCES `sectionimages` (`SectionimageID`)
) TYPE=InnoDB;

--
-- Dumping data for table 'punchimages'
--


--
-- Table structure for table 'results'
--

CREATE TABLE results (
  ResultID bigint(20) NOT NULL default '0',
  Resultname varchar(255) default NULL,
  Resultvalue varchar(255) default NULL,
  PunchID bigint(20) default NULL,
  AlgorithmID bigint(20) default NULL,
  EnteredBy bigint(20) default NULL,
  Date date default NULL,
  PRIMARY KEY  (ResultID),
  KEY ResultID (ResultID),
  KEY PunchID (PunchID),
  KEY AlgorithmID (AlgorithmID),
  CONSTRAINT `0_218` FOREIGN KEY (`AlgorithmID`) REFERENCES `algorithms` (`AlgorithmID`),
  CONSTRAINT `0_219` FOREIGN KEY (`PunchID`) REFERENCES `punch` (`PunchID`)
) TYPE=InnoDB;

--
-- Dumping data for table 'results'
--

--
-- Table structure for table 'section'
--

CREATE TABLE section (
  SectionID bigint(20) NOT NULL default '0',
  Counter int(11) default NULL,
  Stained int(11) default NULL,
  Sectionnumber int(11) default NULL,
  BarcodeID bigint(20) default NULL,
  Thickness int(11) default NULL,
  EnteredBy bigint(20) default NULL,
  Date date default NULL,
  Series int(11) default NULL,
  MicrotometypeID bigint(20) default NULL,
  SlidetypeID bigint(20) default NULL,
  CutterID bigint(20) default NULL,
  ParaffintypeID bigint(20) default NULL,
  PersonID bigint(20) default NULL,
  ArrayblockID bigint(20) default NULL,
  CustomerID bigint(20) default NULL,
  StorageID bigint(20) default NULL,
  PRIMARY KEY  (SectionID),
  KEY SectionID (SectionID),
  KEY ParaffintypeID (ParaffintypeID),
  KEY CutterID (CutterID),
  KEY ArrayblockID (ArrayblockID),
  KEY MicrotometypeID (MicrotometypeID),
  KEY SlidetypeID (SlidetypeID),
  KEY CustomerID (CustomerID),
  KEY PersonID (PersonID),
  KEY iStorageID (StorageID),
  CONSTRAINT `0_283` FOREIGN KEY (`StorageID`) REFERENCES `datadictionary` (`DataID`),
  CONSTRAINT `0_221` FOREIGN KEY (`CutterID`) REFERENCES `datadictionary` (`DataID`),
  CONSTRAINT `0_222` FOREIGN KEY (`PersonID`) REFERENCES `datadictionary` (`DataID`),
  CONSTRAINT `0_223` FOREIGN KEY (`MicrotometypeID`) REFERENCES `datadictionary` (`DataID`),
  CONSTRAINT `0_224` FOREIGN KEY (`ParaffintypeID`) REFERENCES `datadictionary` (`DataID`),
  CONSTRAINT `0_225` FOREIGN KEY (`ArrayblockID`) REFERENCES `arrayblock` (`ArrayblockID`),
  CONSTRAINT `0_226` FOREIGN KEY (`CustomerID`) REFERENCES `datadictionary` (`DataID`),
  CONSTRAINT `0_227` FOREIGN KEY (`SlidetypeID`) REFERENCES `datadictionary` (`DataID`)
) TYPE=InnoDB;

--
-- Dumping data for table 'section'
--

--
-- Table structure for table 'sectionimages'
--

CREATE TABLE sectionimages (
  SectionimageID bigint(20) NOT NULL default '0',
  Image longblob,
  Imagename varchar(255) default NULL,
  Description varchar(255) default NULL,
  Gridding int(11) default NULL,
  SectionID bigint(20) default NULL,
  CapturedByID bigint(20) default NULL,
  DyeingmethodID bigint(20) default NULL,
  StainingID bigint(20) default NULL,
  SmallimageID bigint(20) default NULL,
  PRIMARY KEY  (SectionimageID),
  KEY SectionimageID (SectionimageID),
  KEY SectionID (SectionID),
  KEY StainingID (StainingID),
  KEY CapturedByID (CapturedByID),
  KEY SmallimageID (SmallimageID),
  KEY DyeingmethodID (DyeingmethodID),
  CONSTRAINT `0_275` FOREIGN KEY (`DyeingmethodID`) REFERENCES `datadictionary` (`DataID`),
  CONSTRAINT `0_229` FOREIGN KEY (`SectionID`) REFERENCES `section` (`SectionID`),
  CONSTRAINT `0_230` FOREIGN KEY (`StainingID`) REFERENCES `staining` (`StainingID`),
  CONSTRAINT `0_232` FOREIGN KEY (`CapturedByID`) REFERENCES `datadictionary` (`DataID`),
  CONSTRAINT `0_233` FOREIGN KEY (`SmallimageID`) REFERENCES `smallimages` (`SmallimageID`)
) TYPE=InnoDB;

--
-- Dumping data for table 'sectionimages'
--

--
-- Table structure for table 'sectionimageseq'
--

CREATE TABLE sectionimageseq (
  ID bigint(20) default NULL
) TYPE=MyISAM;

--
-- Dumping data for table 'sectionimageseq'
--

INSERT INTO sectionimageseq VALUES (100);

--
-- Table structure for table 'sectionseq'
--

CREATE TABLE sectionseq (
  ID bigint(20) default NULL
) TYPE=MyISAM;

--
-- Dumping data for table 'sectionseq'
--

INSERT INTO sectionseq VALUES (100);

--
-- Table structure for table 'smallimages'
--

CREATE TABLE smallimages (
  SmallimageID bigint(20) NOT NULL default '0',
  Image longblob,
  Scalefactor float default NULL,
  PRIMARY KEY  (SmallimageID),
  KEY SmallimageID (SmallimageID)
) TYPE=InnoDB;

--
-- Dumping data for table 'smallimages'
--

--
-- Table structure for table 'smallimageseq'
--

CREATE TABLE smallimageseq (
  ID bigint(20) default NULL
) TYPE=MyISAM;

--
-- Dumping data for table 'smallimageseq'
--

INSERT INTO smallimageseq VALUES (100);

--
-- Table structure for table 'staining'
--

CREATE TABLE staining (
  StainingID bigint(20) NOT NULL default '0',
  EnteredBy bigint(20) default NULL,
  Date date default NULL,
  Stainingprotocol longblob,
  Protocolfilename varchar(255) default NULL,
  Comment varchar(255) default NULL,
  Stainingname varchar(255) default NULL,
  ColorID bigint(20) default NULL,
  AntibodyID bigint(20) default NULL,
  AntigenID bigint(20) default NULL,
  PRIMARY KEY  (StainingID),
  KEY StainingID (StainingID),
  KEY AntigenID (AntigenID),
  KEY AntibodyID (AntibodyID),
  KEY ColorID (ColorID),
  CONSTRAINT `0_236` FOREIGN KEY (`AntibodyID`) REFERENCES `antibody` (`AntibodyID`),
  CONSTRAINT `0_237` FOREIGN KEY (`AntigenID`) REFERENCES `antigen` (`AntigenID`),
  CONSTRAINT `0_238` FOREIGN KEY (`ColorID`) REFERENCES `datadictionary` (`DataID`)
) TYPE=InnoDB;

--
-- Dumping data for table 'staining'
--

--
-- Table structure for table 'stainingseq'
--

CREATE TABLE stainingseq (
  ID bigint(20) default NULL
) TYPE=MyISAM;

--
-- Dumping data for table 'stainingseq'
--

INSERT INTO stainingseq VALUES (100);

--
-- Table structure for table 'tissues'
--

CREATE TABLE tissues (
  TissueID bigint(20) NOT NULL default '0',
  SourceID bigint(20) default NULL,
  SiteID bigint(20) default NULL,
  SampleID bigint(20) default NULL,
  Tissuecomment varchar(255) default NULL,
  BehaviourID bigint(20) default NULL,
  SpeciesID bigint(20) default NULL,
  GradeID bigint(20) default NULL,
  MorphologyID bigint(20) default NULL,
  TopographyID bigint(20) default NULL,
  StagingTID bigint(20) default NULL,
  StagingNID bigint(20) default NULL,
  StagingMID bigint(20) default NULL,
  StagingRID bigint(20) default NULL,
  PRIMARY KEY  (TissueID),
  KEY iTissueID (TissueID),
  KEY BehaviourID (BehaviourID),
  KEY SpeciesID (SpeciesID),
  KEY GradeID (GradeID),
  KEY TissueID (TissueID),
  KEY MorphologyID (MorphologyID),
  KEY TopographyID (TopographyID),
  KEY SourceID (SourceID),
  KEY SiteID (SiteID),
  KEY StagingTID (StagingTID),
  KEY StagingNID (StagingNID),
  KEY StagingMID (StagingMID),
  KEY StagingRID (StagingRID),
  CONSTRAINT `0_240` FOREIGN KEY (`GradeID`) REFERENCES `grade` (`GradeID`),
  CONSTRAINT `0_241` FOREIGN KEY (`MorphologyID`) REFERENCES `morphology` (`MorphologyID`),
  CONSTRAINT `0_242` FOREIGN KEY (`SpeciesID`) REFERENCES `datadictionary` (`DataID`),
  CONSTRAINT `0_243` FOREIGN KEY (`SiteID`) REFERENCES `datadictionary` (`DataID`),
  CONSTRAINT `0_244` FOREIGN KEY (`SourceID`) REFERENCES `datadictionary` (`DataID`),
  CONSTRAINT `0_245` FOREIGN KEY (`TopographyID`) REFERENCES `topography` (`TopographyID`),
  CONSTRAINT `0_246` FOREIGN KEY (`BehaviourID`) REFERENCES `behaviour` (`BehaviourID`),
  CONSTRAINT `0_259` FOREIGN KEY (`StagingTID`) REFERENCES `datadictionary` (`DataID`),
  CONSTRAINT `0_261` FOREIGN KEY (`StagingNID`) REFERENCES `datadictionary` (`DataID`),
  CONSTRAINT `0_263` FOREIGN KEY (`StagingMID`) REFERENCES `datadictionary` (`DataID`),
  CONSTRAINT `0_265` FOREIGN KEY (`StagingRID`) REFERENCES `datadictionary` (`DataID`)
) TYPE=InnoDB;

--
-- Dumping data for table 'tissues'
--

--
-- Table structure for table 'tissueseq'
--

CREATE TABLE tissueseq (
  ID bigint(20) default NULL
) TYPE=MyISAM;

--
-- Dumping data for table 'tissueseq'
--

INSERT INTO tissueseq VALUES (100);

--
-- Table structure for table 'topography'
--

CREATE TABLE topography (
  TopographyID bigint(20) NOT NULL default '0',
  Topography varchar(255) default NULL,
  PRIMARY KEY  (TopographyID),
  KEY TopographyID (TopographyID)
) TYPE=InnoDB;

--
-- Dumping data for table 'topography'
--

INSERT INTO topography VALUES (0,'');
INSERT INTO topography VALUES (15,'Esophagus; NOS');
INSERT INTO topography VALUES (16,'Stomach');
INSERT INTO topography VALUES (17,'Small Intestine');
INSERT INTO topography VALUES (18,'Colon');
INSERT INTO topography VALUES (19,'Rectosigmoid junction');
INSERT INTO topography VALUES (20,'Rectum');
INSERT INTO topography VALUES (21,'Anal canal');
INSERT INTO topography VALUES (22,'Liver');
INSERT INTO topography VALUES (23,'Gall Bladder');
INSERT INTO topography VALUES (24,'Ampulla of vater');
INSERT INTO topography VALUES (25,'Pancreas');
INSERT INTO topography VALUES (26,'Overlapping lesion of digestive system where organ cannot be determined');
INSERT INTO topography VALUES (34,'Bronchus and lung');
INSERT INTO topography VALUES (40,'Bone');
INSERT INTO topography VALUES (44,'Skin');
INSERT INTO topography VALUES (49,'connective tissue');
INSERT INTO topography VALUES (50,'Breast');
INSERT INTO topography VALUES (51,'Vulva');
INSERT INTO topography VALUES (52,'Vagina');
INSERT INTO topography VALUES (53,'Cervix uteri');
INSERT INTO topography VALUES (54,'Corpus uteri');
INSERT INTO topography VALUES (55,'Uterus');
INSERT INTO topography VALUES (56,'Ovary');
INSERT INTO topography VALUES (57,'Fallopian Tube');
INSERT INTO topography VALUES (58,'Placenta');
INSERT INTO topography VALUES (60,'Penis');
INSERT INTO topography VALUES (61,'Prostate');
INSERT INTO topography VALUES (62,'Testis');
INSERT INTO topography VALUES (63,'Epididymis');
INSERT INTO topography VALUES (64,'Kidney');
INSERT INTO topography VALUES (65,'Renal pelvis');
INSERT INTO topography VALUES (66,'Ureter');
INSERT INTO topography VALUES (67,'Urinary bladder');
INSERT INTO topography VALUES (73,'Thyroid gland');
INSERT INTO topography VALUES (74,'Adrenal gland');
INSERT INTO topography VALUES (75,'Parathyroid');
INSERT INTO topography VALUES (77,'Lymph nodes');
INSERT INTO topography VALUES (80,'unknown primary site');
INSERT INTO topography VALUES (163,'Antrum ventriculi');
INSERT INTO topography VALUES (253,'Ductus pancreaticus');

SET FOREIGN_KEY_CHECKS = 1;
